/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.entity.impl;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.internal.BatchFetchQueueHelper;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.reactive.loader.entity.impl.ReactiveBatchingEntityLoader;
import org.hibernate.reactive.loader.entity.impl.ReactiveDynamicBatchingEntityLoader;
import org.hibernate.reactive.loader.entity.impl.ReactiveEntityLoader;
import org.hibernate.reactive.util.impl.CompletionStages;

public class ReactiveDynamicBatchingEntityDelegator
extends ReactiveBatchingEntityLoader {
    private final int maxBatchSize;
    private final UniqueEntityLoader singleKeyLoader;
    private final ReactiveDynamicBatchingEntityLoader dynamicLoader;

    public ReactiveDynamicBatchingEntityDelegator(OuterJoinLoadable persister, int maxBatchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
        super(persister);
        this.maxBatchSize = maxBatchSize;
        this.singleKeyLoader = new ReactiveEntityLoader(persister, 1, lockMode, factory, loadQueryInfluencers);
        this.dynamicLoader = new ReactiveDynamicBatchingEntityLoader(persister, maxBatchSize, lockMode, factory, loadQueryInfluencers);
    }

    public ReactiveDynamicBatchingEntityDelegator(OuterJoinLoadable persister, int maxBatchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
        super(persister);
        this.maxBatchSize = maxBatchSize;
        this.singleKeyLoader = new ReactiveEntityLoader(persister, 1, lockOptions, factory, loadQueryInfluencers);
        this.dynamicLoader = new ReactiveDynamicBatchingEntityLoader(persister, maxBatchSize, lockOptions, factory, loadQueryInfluencers);
    }

    @Override
    public CompletionStage<Object> load(Serializable id, Object optionalObject, SharedSessionContractImplementor session, LockOptions lockOptions) {
        return this.load(id, optionalObject, session, lockOptions, null);
    }

    @Override
    public CompletionStage<Object> load(Serializable id, Object optionalObject, SharedSessionContractImplementor session, LockOptions lockOptions, Boolean readOnly) {
        Serializable[] batch = session.getPersistenceContextInternal().getBatchFetchQueue().getEntityBatch(this.persister(), id, this.maxBatchSize, this.persister().getEntityMode());
        int numberOfIds = ArrayHelper.countNonNull((Serializable[])batch);
        if (numberOfIds <= 1) {
            Object result = this.singleKeyLoader.load(id, optionalObject, session, lockOptions);
            if (result == null) {
                BatchFetchQueueHelper.removeBatchLoadableEntityKey((Serializable)id, (EntityPersister)this.persister(), (SharedSessionContractImplementor)session);
            }
            return CompletionStages.completedFuture(result);
        }
        Serializable[] idsToLoad = new Serializable[numberOfIds];
        System.arraycopy(batch, 0, idsToLoad, 0, numberOfIds);
        QueryParameters qp = this.buildQueryParameters(id, idsToLoad, optionalObject, lockOptions, false);
        return this.dynamicLoader.doEntityBatchFetch((SessionImplementor)session, qp, idsToLoad).thenApply(results -> {
            BatchFetchQueueHelper.removeNotFoundBatchLoadableEntityKeys((Serializable[])idsToLoad, (List)results, (EntityPersister)this.persister(), (SharedSessionContractImplementor)session);
            return this.getObjectFromList((List<?>)results, id, session);
        });
    }
}

