/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.entity.impl;

import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.reactive.loader.entity.impl.ReactiveDynamicBatchingEntityLoaderBuilder;
import org.hibernate.reactive.loader.entity.impl.ReactiveEntityLoader;
import org.hibernate.reactive.loader.entity.impl.ReactivePaddedBatchingEntityLoaderBuilder;
import org.hibernate.reactive.loader.entity.impl.ReactivePlanEntityLoader;

public class ReactiveBatchingEntityLoaderBuilder {
    public static ReactiveBatchingEntityLoaderBuilder getBuilder(SessionFactoryImplementor factory) {
        switch (factory.getSessionFactoryOptions().getBatchFetchStyle()) {
            case PADDED: {
                return ReactivePaddedBatchingEntityLoaderBuilder.INSTANCE;
            }
            case DYNAMIC: {
                return ReactiveDynamicBatchingEntityLoaderBuilder.INSTANCE;
            }
        }
        return ReactiveDynamicBatchingEntityLoaderBuilder.INSTANCE;
    }

    public UniqueEntityLoader buildLoader(OuterJoinLoadable persister, int batchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        if (batchSize <= 1) {
            return this.buildNonBatchingLoader(persister, lockMode, factory, influencers);
        }
        return this.buildBatchingLoader(persister, batchSize, lockMode, factory, influencers);
    }

    protected UniqueEntityLoader buildNonBatchingLoader(OuterJoinLoadable persister, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        return new ReactivePlanEntityLoader.Builder(persister).withLockMode(lockMode).withInfluencers(influencers).byPrimaryKey();
    }

    public UniqueEntityLoader buildLoader(OuterJoinLoadable persister, int batchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        if (batchSize <= 1) {
            return this.buildNonBatchingLoader(persister, lockOptions, factory, influencers);
        }
        return this.buildBatchingLoader(persister, batchSize, lockOptions, factory, influencers);
    }

    protected UniqueEntityLoader buildNonBatchingLoader(OuterJoinLoadable persister, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        return new ReactivePlanEntityLoader.Builder(persister).withLockMode(lockOptions.getLockMode()).withInfluencers(influencers).byPrimaryKey();
    }

    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable persister, int batchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        return new ReactiveEntityLoader(persister, factory, lockMode, influencers);
    }

    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable persister, int batchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        return new ReactiveEntityLoader(persister, factory, lockOptions.getLockMode(), influencers);
    }
}

