/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.entity.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.LockOptions;
import org.hibernate.engine.internal.BatchFetchQueueHelper;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.loader.entity.ReactiveUniqueEntityLoader;
import org.hibernate.reactive.loader.entity.impl.ReactiveEntityLoader;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.type.Type;

public abstract class ReactiveBatchingEntityLoader
implements ReactiveUniqueEntityLoader {
    private final EntityPersister persister;

    public ReactiveBatchingEntityLoader(OuterJoinLoadable persister) {
        this.persister = persister;
    }

    public EntityPersister persister() {
        return this.persister;
    }

    @Override
    public CompletionStage<Object> load(Serializable id, Object optionalObject, SharedSessionContractImplementor session) {
        return this.load(id, optionalObject, session, LockOptions.NONE);
    }

    @Override
    public CompletionStage<Object> load(Serializable id, Object optionalObject, SharedSessionContractImplementor session, Boolean readOnly) {
        return this.load(id, optionalObject, session, LockOptions.NONE, readOnly);
    }

    @Override
    public CompletionStage<Object> load(Object id, SharedSessionContractImplementor session, LockOptions lockOptions) {
        throw new UnsupportedOperationException();
    }

    protected QueryParameters buildQueryParameters(Serializable id, Serializable[] ids, Object optionalObject, LockOptions lockOptions, Boolean readOnly) {
        Object[] types = new Type[ids.length];
        Arrays.fill(types, this.persister().getIdentifierType());
        QueryParameters qp = new QueryParameters();
        qp.setPositionalParameterTypes((Type[])types);
        qp.setPositionalParameterValues((Object[])ids);
        qp.setOptionalObject(optionalObject);
        qp.setOptionalEntityName(this.persister().getEntityName());
        qp.setOptionalId(id);
        qp.setLockOptions(lockOptions);
        if (readOnly != null) {
            qp.setReadOnly(readOnly.booleanValue());
        }
        return qp;
    }

    protected Object getObjectFromList(List<?> results, Serializable id, SharedSessionContractImplementor session) {
        for (Object obj : results) {
            boolean equal = this.persister.getIdentifierType().isEqual((Object)id, (Object)session.getContextEntityIdentifier(obj), session.getFactory());
            if (!equal) continue;
            return obj;
        }
        return null;
    }

    protected CompletionStage<Object> doBatchLoad(Serializable id, ReactiveEntityLoader loaderToUse, SharedSessionContractImplementor session, Serializable[] ids, Object optionalObject, LockOptions lockOptions, Boolean readOnly) {
        QueryParameters parameters = this.buildQueryParameters(id, ids, optionalObject, lockOptions, readOnly);
        return loaderToUse.doReactiveQueryAndInitializeNonLazyCollections((SessionImplementor)session, parameters, false).handle((list, err) -> {
            Object result = this.getObjectFromList((List<?>)list, id, session);
            BatchFetchQueueHelper.removeNotFoundBatchLoadableEntityKeys((Serializable[])ids, (List)list, (EntityPersister)this.persister(), (SharedSessionContractImplementor)session);
            CompletionStages.logSqlException(err, () -> "could not load an entity batch: " + MessageHelper.infoString((EntityPersister)this.persister(), (Serializable[])ids, (SessionFactoryImplementor)session.getFactory()), loaderToUse.getSQLString());
            return CompletionStages.returnOrRethrow(err, result);
        });
    }
}

