/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.entity.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.JoinWalker;
import org.hibernate.loader.entity.AbstractEntityLoader;
import org.hibernate.loader.spi.AfterLoadAction;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.loader.ReactiveLoaderBasedLoader;
import org.hibernate.reactive.loader.ReactiveLoaderBasedResultSetProcessor;
import org.hibernate.reactive.loader.ReactiveResultSetProcessor;
import org.hibernate.reactive.loader.entity.ReactiveUniqueEntityLoader;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.impl.Parameters;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;

public abstract class ReactiveAbstractEntityLoader
extends AbstractEntityLoader
implements ReactiveUniqueEntityLoader,
ReactiveLoaderBasedLoader {
    protected static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final ReactiveLoaderBasedResultSetProcessor resultSetProcessor = new ReactiveLoaderBasedResultSetProcessor(this);
    private final Parameters parameters;

    protected ReactiveAbstractEntityLoader(OuterJoinLoadable persister, Type uniqueKeyType, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
        super(persister, uniqueKeyType, factory, loadQueryInfluencers);
        this.parameters = Parameters.instance(factory.getJdbcServices().getDialect());
    }

    protected void initFromWalker(JoinWalker walker) {
        String processedSQLString = this.parameters().process(walker.getSQLString());
        walker.setSql(processedSQLString);
        super.initFromWalker(walker);
    }

    @Override
    public Parameters parameters() {
        return this.parameters;
    }

    protected CompletionStage<List<Object>> doReactiveQueryAndInitializeNonLazyCollections(SessionImplementor session, QueryParameters queryParameters, boolean returnProxies) {
        return this.doReactiveQueryAndInitializeNonLazyCollections(this.getSQLString(), (SharedSessionContractImplementor)session, queryParameters, returnProxies, null);
    }

    protected CompletionStage<Object> load(SharedSessionContractImplementor session, Object id, Object optionalObject, Serializable optionalId, LockOptions lockOptions, Boolean readOnly) {
        return this.loadReactiveEntity((SessionImplementor)session, id, this.uniqueKeyType, optionalObject, this.entityName, optionalId, lockOptions).thenApply(list -> {
            switch (list.size()) {
                case 1: {
                    return list.get(0);
                }
                case 0: {
                    return null;
                }
            }
            if (this.getCollectionOwners() != null) {
                return list.get(0);
            }
            throw LOG.moreThanOneRowWithTheGivenIdentifier(id, this.persister.getEntityName());
        });
    }

    protected CompletionStage<List<Object>> loadReactiveEntity(SessionImplementor session, Object id, Type identifierType, Object optionalObject, String optionalEntityName, Serializable optionalIdentifier, LockOptions lockOptions) throws HibernateException {
        QueryParameters parameters = this.buildQueryParameters(id, identifierType, optionalObject, optionalEntityName, optionalIdentifier, lockOptions);
        return this.doReactiveQueryAndInitializeNonLazyCollections(session, parameters, false).handle((list, err) -> {
            LOG.debug("Done entity load");
            Loadable[] persisters = this.getEntityPersisters();
            CompletionStages.logSqlException(err, () -> "could not load an entity: " + MessageHelper.infoString((EntityPersister)persisters[persisters.length - 1], (Object)id, (Type)identifierType, (SessionFactoryImplementor)this.getFactory()), this.getSQLString());
            return CompletionStages.returnOrRethrow(err, list);
        });
    }

    private QueryParameters buildQueryParameters(Object id, Type identifierType, Object optionalObject, String optionalEntityName, Serializable optionalIdentifier, LockOptions lockOptions) {
        QueryParameters parameters = new QueryParameters();
        parameters.setPositionalParameterTypes(new Type[]{identifierType});
        parameters.setPositionalParameterValues(new Object[]{id});
        parameters.setOptionalObject(optionalObject);
        parameters.setOptionalEntityName(optionalEntityName);
        parameters.setOptionalId(optionalIdentifier);
        parameters.setLockOptions(lockOptions);
        return parameters;
    }

    @Override
    public CompletionStage<Object> load(Serializable id, Object optionalObject, SharedSessionContractImplementor session) {
        return this.load(id, optionalObject, session, LockOptions.NONE, null);
    }

    @Override
    public CompletionStage<Object> load(Serializable id, Object optionalObject, SharedSessionContractImplementor session, Boolean readOnly) {
        return this.load(id, optionalObject, session, LockOptions.NONE, readOnly);
    }

    @Override
    public CompletionStage<Object> load(Serializable id, Object optionalObject, SharedSessionContractImplementor session, LockOptions lockOptions) {
        return this.load(id, optionalObject, session, lockOptions, null);
    }

    @Override
    public CompletionStage<Object> load(Serializable id, Object optionalObject, SharedSessionContractImplementor session, LockOptions lockOptions, Boolean readOnly) {
        return this.load(session, id, optionalObject, id, lockOptions, readOnly);
    }

    @Override
    public CompletionStage<Object> load(Object id, SharedSessionContractImplementor session, LockOptions lockOptions) {
        return this.load(session, id, null, null, lockOptions, null);
    }

    @Override
    public String preprocessSQL(String sql, QueryParameters queryParameters, SessionFactoryImplementor factory, List<AfterLoadAction> afterLoadActions) {
        return super.preprocessSQL(sql, queryParameters, factory, afterLoadActions);
    }

    public List<Object> processResultSet(ResultSet resultSet, QueryParameters queryParameters, SharedSessionContractImplementor session, boolean returnProxies, ResultTransformer forcedResultTransformer, int maxRows, List<AfterLoadAction> afterLoadActions) {
        throw new UnsupportedOperationException("use #reactiveProcessResultSet instead.");
    }

    @Override
    public ReactiveResultSetProcessor getReactiveResultSetProcessor() {
        return this.resultSetProcessor;
    }

    @Override
    public boolean isSubselectLoadingEnabled() {
        return super.isSubselectLoadingEnabled();
    }

    @Override
    public List<Object> getRowsFromResultSet(ResultSet rs, QueryParameters queryParameters, SharedSessionContractImplementor session, boolean returnProxies, ResultTransformer forcedResultTransformer, int maxRows, List<Object> hydratedObjects, List<EntityKey[]> subselectResultKeys) throws SQLException {
        return super.getRowsFromResultSet(rs, queryParameters, session, returnProxies, forcedResultTransformer, maxRows, hydratedObjects, subselectResultKeys);
    }

    @Override
    public void createSubselects(List keys, QueryParameters queryParameters, SharedSessionContractImplementor session) {
        super.createSubselects(keys, queryParameters, session);
    }

    @Override
    public void endCollectionLoad(Object resultSetId, SharedSessionContractImplementor session, CollectionPersister collectionPersister) {
        super.endCollectionLoad(resultSetId, session, collectionPersister);
    }

    public List<Object> doQueryAndInitializeNonLazyCollections(SharedSessionContractImplementor session, QueryParameters queryParameters, boolean returnProxies) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public List<Object> doQueryAndInitializeNonLazyCollections(SharedSessionContractImplementor session, QueryParameters queryParameters, boolean returnProxies, ResultTransformer forcedResultTransformer) throws HibernateException {
        throw new UnsupportedOperationException();
    }
}

