/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.collection.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.loader.collection.impl.ReactiveBasicCollectionLoader;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.type.Type;

public class ReactiveSubselectCollectionLoader
extends ReactiveBasicCollectionLoader {
    private final Serializable[] keys;
    private final Type[] types;
    private final Object[] values;
    private final Map<String, TypedValue> namedParameters;
    private final Map<String, int[]> namedParameterLocMap;

    public ReactiveSubselectCollectionLoader(QueryableCollection persister, String subquery, Collection entityKeys, QueryParameters queryParameters, Map<String, int[]> namedParameterLocMap, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        super(persister, 1, subquery, factory, loadQueryInfluencers);
        this.keys = new Serializable[entityKeys.size()];
        Iterator iter = entityKeys.iterator();
        int i = 0;
        while (iter.hasNext()) {
            this.keys[i++] = ((EntityKey)iter.next()).getIdentifier();
        }
        this.namedParameters = queryParameters.getNamedParameters();
        this.types = queryParameters.getFilteredPositionalParameterTypes();
        this.values = queryParameters.getFilteredPositionalParameterValues();
        this.namedParameterLocMap = namedParameterLocMap;
    }

    @Override
    public void initialize(Serializable id, SharedSessionContractImplementor session) throws HibernateException {
        this.loadCollectionSubselect(session, this.keys, this.values, this.types, this.namedParameters, this.getKeyType());
    }

    @Override
    public CompletionStage<Void> reactiveInitialize(Serializable id, SharedSessionContractImplementor session) throws HibernateException {
        return this.reactiveLoadCollectionSubselect(session, this.keys, this.values, this.types, this.namedParameters, this.getKeyType());
    }

    protected final CompletionStage<Void> reactiveLoadCollectionSubselect(SharedSessionContractImplementor session, Serializable[] ids, Object[] parameterValues, Type[] parameterTypes, Map<String, TypedValue> namedParameters, Type type) throws HibernateException {
        QueryParameters parameters = new QueryParameters(parameterTypes, parameterValues, namedParameters, ids);
        return this.doReactiveQueryAndInitializeNonLazyCollections(session, parameters, true).handle((list, err) -> {
            CompletionStages.logSqlException(err, () -> "could not load collection by subselect: " + MessageHelper.collectionInfoString((CollectionPersister)this.getCollectionPersisters()[0], (Serializable[])ids, (SessionFactoryImplementor)this.getFactory()), this.getSQLString());
            return (Void)CompletionStages.returnNullorRethrow(err);
        });
    }

    public int[] getNamedParameterLocs(String name) {
        return this.namedParameterLocMap.get(name);
    }
}

