/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.collection.impl;

import org.hibernate.MappingException;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.reactive.loader.collection.impl.ReactiveBatchingCollectionInitializerBuilder;
import org.hibernate.reactive.loader.collection.impl.ReactiveCollectionLoader;
import org.hibernate.reactive.loader.collection.impl.ReactiveOneToManyLoader;
import org.hibernate.reactive.loader.collection.impl.ReactivePaddedBatchingCollectionInitializer;

public class ReactivePaddedBatchingCollectionInitializerBuilder
extends ReactiveBatchingCollectionInitializerBuilder {
    public static final ReactivePaddedBatchingCollectionInitializerBuilder INSTANCE = new ReactivePaddedBatchingCollectionInitializerBuilder();

    @Override
    public ReactiveCollectionLoader createRealBatchingCollectionInitializer(QueryableCollection persister, int maxBatchSize, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        int[] batchSizes = ArrayHelper.getBatchSizes((int)maxBatchSize);
        ReactiveCollectionLoader[] loaders = new ReactiveCollectionLoader[batchSizes.length];
        int i = 0;
        if (i < batchSizes.length) {
            throw new UnsupportedOperationException();
        }
        return new ReactivePaddedBatchingCollectionInitializer(persister, batchSizes, loaders, factory, loadQueryInfluencers);
    }

    @Override
    public ReactiveCollectionLoader createRealBatchingOneToManyInitializer(QueryableCollection persister, int maxBatchSize, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        int[] batchSizes = ArrayHelper.getBatchSizes((int)maxBatchSize);
        ReactiveCollectionLoader[] loaders = new ReactiveCollectionLoader[batchSizes.length];
        for (int i = 0; i < batchSizes.length; ++i) {
            loaders[i] = new ReactiveOneToManyLoader(persister, batchSizes[i], factory, loadQueryInfluencers);
        }
        return new ReactivePaddedBatchingCollectionInitializer(persister, batchSizes, loaders, factory, loadQueryInfluencers);
    }
}

