/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.collection.impl;

import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.reactive.loader.collection.impl.ReactiveCollectionLoader;

class ReactivePaddedBatchingCollectionInitializer
extends ReactiveCollectionLoader {
    private QueryableCollection persister;
    private final int[] batchSizes;
    private final ReactiveCollectionLoader[] loaders;

    public ReactivePaddedBatchingCollectionInitializer(QueryableCollection persister, int[] batchSizes, ReactiveCollectionLoader[] loaders, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
        super(persister, factory, loadQueryInfluencers);
        this.persister = persister;
        this.batchSizes = batchSizes;
        this.loaders = loaders;
    }

    @Override
    public CompletionStage<Void> reactiveInitialize(Serializable id, SharedSessionContractImplementor session) {
        Serializable[] batch = session.getPersistenceContextInternal().getBatchFetchQueue().getCollectionBatch((CollectionPersister)this.persister, id, this.batchSizes[0]);
        int numberOfIds = ArrayHelper.countNonNull((Serializable[])batch);
        if (numberOfIds <= 1) {
            return this.loaders[this.batchSizes.length - 1].reactiveLoadCollection(session, id, this.persister.getKeyType());
        }
        int indexToUse = this.batchSizes.length - 1;
        int i = 0;
        while (i < this.batchSizes.length - 1 && this.batchSizes[i] >= numberOfIds) {
            indexToUse = i++;
        }
        Serializable[] idsToLoad = new Serializable[this.batchSizes[indexToUse]];
        System.arraycopy(batch, 0, idsToLoad, 0, numberOfIds);
        for (int i2 = numberOfIds; i2 < this.batchSizes[indexToUse]; ++i2) {
            idsToLoad[i2] = id;
        }
        return this.loaders[indexToUse].reactiveLoadCollectionBatch((SessionImplementor)session, idsToLoad, this.persister.getKeyType());
    }
}

