/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.collection.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.JoinWalker;
import org.hibernate.loader.collection.BasicCollectionJoinWalker;
import org.hibernate.loader.collection.OneToManyJoinWalker;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.loader.collection.impl.ReactiveCollectionLoader;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.type.Type;

class ReactiveDynamicBatchingCollectionInitializer
extends ReactiveCollectionLoader {
    private final String sqlTemplate;
    private final String alias;

    public ReactiveDynamicBatchingCollectionInitializer(QueryableCollection collectionPersister, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        super(collectionPersister, factory, influencers);
        JoinWalker walker = this.buildJoinWalker(collectionPersister, factory, influencers);
        this.initFromWalker(walker);
        this.sqlTemplate = walker.getSQLString();
        this.alias = StringHelper.generateAlias((String)collectionPersister.getRole(), (int)0);
        this.postInstantiate();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("SQL-template for dynamic collection [%s] batch-fetching : %s", (Object)collectionPersister.getRole(), (Object)this.sqlTemplate);
        }
    }

    private JoinWalker buildJoinWalker(QueryableCollection collectionPersister, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        if (collectionPersister.isOneToMany()) {
            return new OneToManyJoinWalker(collectionPersister, -1, null, factory, influencers){

                protected StringBuilder whereString(String alias, String[] columnNames, String subselect, int batchSize) {
                    if (subselect != null) {
                        return super.whereString(alias, columnNames, subselect, batchSize);
                    }
                    return StringHelper.buildBatchFetchRestrictionFragment((String)alias, (String[])columnNames, (Dialect)this.getFactory().getDialect());
                }
            };
        }
        return new BasicCollectionJoinWalker(collectionPersister, -1, null, factory, influencers){

            protected StringBuilder whereString(String alias, String[] columnNames, String subselect, int batchSize) {
                if (subselect != null) {
                    return super.whereString(alias, columnNames, subselect, batchSize);
                }
                return StringHelper.buildBatchFetchRestrictionFragment((String)alias, (String[])columnNames, (Dialect)this.getFactory().getDialect());
            }
        };
    }

    public final CompletionStage<Void> doBatchedCollectionLoad(SessionImplementor session, Serializable[] ids, Type type) throws HibernateException {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Batch loading collection: %s", (Object)MessageHelper.collectionInfoString((CollectionPersister)this.getCollectionPersisters()[0], (Serializable[])ids, (SessionFactoryImplementor)this.getFactory()));
        }
        Object[] idTypes = new Type[ids.length];
        Arrays.fill(idTypes, type);
        QueryParameters queryParameters = new QueryParameters((Type[])idTypes, (Object[])ids, ids);
        String sql = StringHelper.expandBatchIdPlaceholder((String)this.sqlTemplate, (Serializable[])ids, (String)this.alias, (String[])this.collectionPersister().getKeyColumnNames(), (Dialect)session.getJdbcServices().getJdbcEnvironment().getDialect());
        return this.doReactiveQueryAndInitializeNonLazyCollections(sql, (SharedSessionContractImplementor)session, queryParameters).handle((list, err) -> {
            CompletionStages.logSqlException(err, () -> "could not initialize a collection batch: " + MessageHelper.collectionInfoString((CollectionPersister)this.getCollectionPersisters()[0], (Serializable[])ids, (SessionFactoryImplementor)this.getFactory()), this.getSQLString());
            LOG.debug((Object)"Done batch load");
            return (Void)CompletionStages.returnNullorRethrow(err);
        });
    }
}

