/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.collection.impl;

import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.reactive.loader.collection.impl.ReactiveCollectionLoader;
import org.hibernate.reactive.loader.collection.impl.ReactiveDynamicBatchingCollectionInitializer;
import org.hibernate.reactive.loader.collection.impl.ReactiveOneToManyLoader;

public class ReactiveDynamicBatchingCollectionDelegator
extends ReactiveCollectionLoader {
    private final int maxBatchSize;
    private final ReactiveCollectionLoader singleKeyLoader;
    private final ReactiveDynamicBatchingCollectionInitializer batchLoader;

    public ReactiveDynamicBatchingCollectionDelegator(QueryableCollection collectionPersister, int maxBatchSize, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        super(collectionPersister, factory, influencers);
        this.maxBatchSize = maxBatchSize;
        if (!collectionPersister.isOneToMany()) {
            throw new UnsupportedOperationException();
        }
        this.singleKeyLoader = new ReactiveOneToManyLoader(collectionPersister, 1, factory, influencers);
        this.batchLoader = new ReactiveDynamicBatchingCollectionInitializer(collectionPersister, factory, influencers);
    }

    @Override
    public void initialize(Serializable id, SharedSessionContractImplementor session) throws HibernateException {
        Serializable[] batch = session.getPersistenceContextInternal().getBatchFetchQueue().getCollectionBatch((CollectionPersister)this.collectionPersister(), id, this.maxBatchSize);
        int numberOfIds = ArrayHelper.countNonNull((Serializable[])batch);
        if (numberOfIds <= 1) {
            this.singleKeyLoader.loadCollection(session, id, this.collectionPersister().getKeyType());
            return;
        }
        Serializable[] idsToLoad = new Serializable[numberOfIds];
        System.arraycopy(batch, 0, idsToLoad, 0, numberOfIds);
        this.batchLoader.doBatchedCollectionLoad((SessionImplementor)session, idsToLoad, this.collectionPersister().getKeyType());
    }

    @Override
    public CompletionStage<Void> reactiveInitialize(Serializable id, SharedSessionContractImplementor session) {
        Serializable[] batch = session.getPersistenceContextInternal().getBatchFetchQueue().getCollectionBatch((CollectionPersister)this.collectionPersister(), id, this.maxBatchSize);
        int numberOfIds = ArrayHelper.countNonNull((Serializable[])batch);
        if (numberOfIds <= 1) {
            return this.singleKeyLoader.reactiveLoadCollection(session, id, this.collectionPersister().getKeyType());
        }
        Serializable[] idsToLoad = new Serializable[numberOfIds];
        System.arraycopy(batch, 0, idsToLoad, 0, numberOfIds);
        return this.batchLoader.doBatchedCollectionLoad((SessionImplementor)session, idsToLoad, this.collectionPersister().getKeyType());
    }
}

