/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.collection.impl;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.JoinWalker;
import org.hibernate.loader.collection.CollectionLoader;
import org.hibernate.loader.spi.AfterLoadAction;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.loader.ReactiveLoaderBasedLoader;
import org.hibernate.reactive.loader.ReactiveLoaderBasedResultSetProcessor;
import org.hibernate.reactive.loader.ReactiveResultSetProcessor;
import org.hibernate.reactive.loader.collection.ReactiveCollectionInitializer;
import org.hibernate.reactive.pool.impl.Parameters;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;

public class ReactiveCollectionLoader
extends CollectionLoader
implements ReactiveCollectionInitializer,
ReactiveLoaderBasedLoader {
    private final ReactiveResultSetProcessor reactiveResultSetProcessor = new ReactiveLoaderBasedResultSetProcessor(this);
    private final Parameters parameters;
    private final boolean filtersAreDisabled;

    public ReactiveCollectionLoader(QueryableCollection collectionPersister, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
        super(collectionPersister, factory, loadQueryInfluencers);
        this.parameters = Parameters.instance(factory.getJdbcServices().getDialect());
        this.filtersAreDisabled = !loadQueryInfluencers.hasEnabledFilters();
    }

    protected void initFromWalker(JoinWalker walker) {
        if (this.filtersAreDisabled) {
            String processedSQL = this.parameters().process(walker.getSQLString());
            walker.setSql(processedSQL);
        }
        super.initFromWalker(walker);
    }

    @Override
    public Parameters parameters() {
        return this.parameters;
    }

    protected CompletionStage<List<Object>> doReactiveQueryAndInitializeNonLazyCollections(SharedSessionContractImplementor session, QueryParameters queryParameters, boolean returnProxies) {
        return this.doReactiveQueryAndInitializeNonLazyCollections(this.getSQLString(), session, queryParameters, returnProxies, null);
    }

    @Deprecated
    public void initialize(Serializable id, SharedSessionContractImplementor session) throws HibernateException {
        throw new UnsupportedOperationException("Use the reactive method instead: reactiveInitialize");
    }

    @Override
    public CompletionStage<Void> reactiveInitialize(Serializable id, SharedSessionContractImplementor session) throws HibernateException {
        return this.reactiveLoadCollection(session, id, this.getKeyType());
    }

    public CompletionStage<Void> reactiveLoadCollection(SharedSessionContractImplementor session, Serializable id, Type type) throws HibernateException {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Loading collection: %s", (Object)MessageHelper.collectionInfoString((CollectionPersister)this.collectionPersister(), (Serializable)id, (SessionFactoryImplementor)this.getFactory()));
        }
        Object[] ids = new Serializable[]{id};
        QueryParameters parameters = new QueryParameters(new Type[]{type}, ids, (Serializable[])ids);
        return this.doReactiveQueryAndInitializeNonLazyCollections(session, parameters, true).handle((list, err) -> {
            CompletionStages.logSqlException(err, () -> "could not initialize a collection: " + MessageHelper.collectionInfoString((CollectionPersister)this.collectionPersister(), (Serializable)id, (SessionFactoryImplementor)this.getFactory()), this.getSQLString());
            LOG.debug((Object)"Done loading collection");
            return (Void)CompletionStages.returnNullorRethrow(err);
        });
    }

    public final CompletionStage<Void> reactiveLoadCollectionBatch(SessionImplementor session, Serializable[] ids, Type type) throws HibernateException {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Batch loading collection: %s", (Object)MessageHelper.collectionInfoString((CollectionPersister)this.getCollectionPersisters()[0], (Serializable[])ids, (SessionFactoryImplementor)this.getFactory()));
        }
        Object[] idTypes = new Type[ids.length];
        Arrays.fill(idTypes, type);
        QueryParameters parameters = new QueryParameters((Type[])idTypes, (Object[])ids, ids);
        return this.doReactiveQueryAndInitializeNonLazyCollections((SharedSessionContractImplementor)session, parameters, true).handle((list, err) -> {
            CompletionStages.logSqlException(err, () -> "could not initialize a collection batch: " + MessageHelper.collectionInfoString((CollectionPersister)this.getCollectionPersisters()[0], (Serializable[])ids, (SessionFactoryImplementor)this.getFactory()), this.getSQLString());
            LOG.debug((Object)"Done batch load");
            return (Void)CompletionStages.returnNullorRethrow(err);
        });
    }

    @Override
    public ReactiveResultSetProcessor getReactiveResultSetProcessor() {
        return this.reactiveResultSetProcessor;
    }

    @Override
    public String preprocessSQL(String sql, QueryParameters queryParameters, SessionFactoryImplementor factory, List<AfterLoadAction> afterLoadActions) {
        return super.preprocessSQL(sql, queryParameters, factory, afterLoadActions);
    }

    public List<Object> processResultSet(ResultSet resultSet, QueryParameters queryParameters, SharedSessionContractImplementor session, boolean returnProxies, ResultTransformer forcedResultTransformer, int maxRows, List<AfterLoadAction> afterLoadActions) {
        throw new UnsupportedOperationException("use #reactiveProcessResultSet instead.");
    }

    @Override
    public boolean isSubselectLoadingEnabled() {
        return super.isSubselectLoadingEnabled();
    }

    @Override
    public List<Object> getRowsFromResultSet(ResultSet rs, QueryParameters queryParameters, SharedSessionContractImplementor session, boolean returnProxies, ResultTransformer forcedResultTransformer, int maxRows, List<Object> hydratedObjects, List<EntityKey[]> subselectResultKeys) throws SQLException {
        return super.getRowsFromResultSet(rs, queryParameters, session, returnProxies, forcedResultTransformer, maxRows, hydratedObjects, subselectResultKeys);
    }

    @Override
    public void createSubselects(List keys, QueryParameters queryParameters, SharedSessionContractImplementor session) {
        super.createSubselects(keys, queryParameters, session);
    }

    @Override
    public void endCollectionLoad(Object resultSetId, SharedSessionContractImplementor session, CollectionPersister collectionPersister) {
        super.endCollectionLoad(resultSetId, session, collectionPersister);
    }
}

