/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.collection.impl;

import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.reactive.loader.collection.impl.ReactiveBasicCollectionLoader;
import org.hibernate.reactive.loader.collection.impl.ReactiveCollectionLoader;
import org.hibernate.reactive.loader.collection.impl.ReactiveDynamicBatchingCollectionInitializerBuilder;
import org.hibernate.reactive.loader.collection.impl.ReactiveOneToManyLoader;
import org.hibernate.reactive.loader.collection.impl.ReactivePaddedBatchingCollectionInitializerBuilder;

public abstract class ReactiveBatchingCollectionInitializerBuilder {
    public static ReactiveBatchingCollectionInitializerBuilder getBuilder(SessionFactoryImplementor factory) {
        switch (factory.getSessionFactoryOptions().getBatchFetchStyle()) {
            case PADDED: {
                return ReactivePaddedBatchingCollectionInitializerBuilder.INSTANCE;
            }
            case DYNAMIC: {
                return ReactiveDynamicBatchingCollectionInitializerBuilder.INSTANCE;
            }
        }
        return ReactivePaddedBatchingCollectionInitializerBuilder.INSTANCE;
    }

    public ReactiveCollectionLoader createBatchingCollectionInitializer(QueryableCollection persister, int maxBatchSize, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        if (maxBatchSize <= 1) {
            return this.buildNonBatchingLoader(persister, factory, influencers);
        }
        return this.createRealBatchingCollectionInitializer(persister, maxBatchSize, factory, influencers);
    }

    protected abstract ReactiveCollectionLoader createRealBatchingCollectionInitializer(QueryableCollection var1, int var2, SessionFactoryImplementor var3, LoadQueryInfluencers var4);

    public ReactiveCollectionLoader createBatchingOneToManyInitializer(QueryableCollection persister, int maxBatchSize, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        if (maxBatchSize <= 1) {
            return this.buildNonBatchingLoader(persister, factory, influencers);
        }
        return this.createRealBatchingOneToManyInitializer(persister, maxBatchSize, factory, influencers);
    }

    protected abstract ReactiveCollectionLoader createRealBatchingOneToManyInitializer(QueryableCollection var1, int var2, SessionFactoryImplementor var3, LoadQueryInfluencers var4);

    protected ReactiveCollectionLoader buildNonBatchingLoader(QueryableCollection persister, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        return persister.isOneToMany() ? new ReactiveOneToManyLoader(persister, factory, influencers) : new ReactiveBasicCollectionLoader(persister, factory, influencers);
    }
}

