/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.collection.impl;

import org.hibernate.MappingException;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.JoinWalker;
import org.hibernate.loader.collection.BasicCollectionJoinWalker;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.reactive.loader.collection.impl.ReactiveCollectionLoader;

public class ReactiveBasicCollectionLoader
extends ReactiveCollectionLoader {
    public ReactiveBasicCollectionLoader(QueryableCollection collectionPersister, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
        this(collectionPersister, 1, factory, loadQueryInfluencers);
    }

    public ReactiveBasicCollectionLoader(QueryableCollection collectionPersister, int batchSize, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(collectionPersister, batchSize, null, factory, loadQueryInfluencers);
    }

    public ReactiveBasicCollectionLoader(QueryableCollection collectionPersister, int batchSize, String subquery, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        super(collectionPersister, factory, loadQueryInfluencers);
        this.initFromWalker((JoinWalker)new BasicCollectionJoinWalker(collectionPersister, batchSize, subquery, factory, loadQueryInfluencers));
        this.postInstantiate();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Static select for one-to-many %s: %s", (Object)collectionPersister.getRole(), (Object)this.getSQLString());
        }
    }
}

