/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader;

import java.lang.invoke.MethodHandles;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.AssertionFailure;
import org.hibernate.engine.internal.TwoPhaseLoad;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.loader.plan.exec.query.spi.NamedParameterContext;
import org.hibernate.loader.spi.AfterLoadAction;
import org.hibernate.reactive.engine.impl.EntityTypes;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.transform.ResultTransformer;

public interface ReactiveResultSetProcessor {
    public static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public CompletionStage<List<Object>> reactiveExtractResults(ResultSet var1, SharedSessionContractImplementor var2, QueryParameters var3, NamedParameterContext var4, boolean var5, boolean var6, ResultTransformer var7, List<AfterLoadAction> var8) throws SQLException;

    default public CompletionStage<Void> initializeEntity(Object entity, boolean readOnly, SharedSessionContractImplementor session, PreLoadEvent preLoadEvent) {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        EntityEntry entityEntry = persistenceContext.getEntry(entity);
        if (entityEntry == null) {
            throw new AssertionFailure("possible non-threadsafe access to the session");
        }
        TwoPhaseLoad.initializeEntityEntryLoadedState((Object)entity, (EntityEntry)entityEntry, (SharedSessionContractImplementor)session, (entityType, value, source, owner, overridingEager) -> entityType.isEager(overridingEager) ? EntityTypes.resolve(entityType, value, owner, source) : entityType.resolve(value, source, owner, overridingEager));
        Object[] hydratedState = entityEntry.getLoadedState();
        CompletionStage<Void> loop = CompletionStages.voidFuture();
        for (int i = 0; i < hydratedState.length; ++i) {
            Object state = hydratedState[i];
            if (!(state instanceof CompletionStage)) continue;
            int currentIndex = i;
            loop = loop.thenCompose(v -> (CompletionStage)state).thenAccept(initializedEntity -> {
                hydratedState[currentIndex] = initializedEntity;
            });
        }
        return loop.thenAccept(v -> TwoPhaseLoad.initializeEntityFromEntityEntryLoadedState((Object)entity, (EntityEntry)entityEntry, (boolean)readOnly, (SharedSessionContractImplementor)session, (PreLoadEvent)preLoadEvent));
    }
}

