/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader;

import java.lang.invoke.MethodHandles;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.internal.TwoPhaseLoad;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.loader.plan.exec.query.spi.NamedParameterContext;
import org.hibernate.loader.spi.AfterLoadAction;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.reactive.loader.ReactiveLoaderBasedLoader;
import org.hibernate.reactive.loader.ReactiveResultSetProcessor;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.transform.ResultTransformer;

public class ReactiveLoaderBasedResultSetProcessor
implements ReactiveResultSetProcessor {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final ReactiveLoaderBasedLoader loader;

    public ReactiveLoaderBasedResultSetProcessor(ReactiveLoaderBasedLoader loader) {
        this.loader = loader;
    }

    @Override
    public CompletionStage<List<Object>> reactiveExtractResults(ResultSet rs, SharedSessionContractImplementor session, QueryParameters queryParameters, NamedParameterContext namedParameterContext, boolean returnProxies, boolean readOnly, ResultTransformer forcedResultTransformer, List<AfterLoadAction> afterLoadActionList) throws SQLException {
        int entitySpan = this.loader.getEntityPersisters().length;
        RowSelection rowSelection = queryParameters.getRowSelection();
        int maxRows = LimitHelper.hasMaxRows((RowSelection)rowSelection) ? rowSelection.getMaxRows() : Integer.MAX_VALUE;
        boolean createSubselects = this.loader.isSubselectLoadingEnabled();
        ArrayList<EntityKey[]> subselectResultKeys = createSubselects ? new ArrayList<EntityKey[]>() : null;
        ArrayList<Object> hydratedObjects = entitySpan == 0 ? null : new ArrayList<Object>(entitySpan * 10);
        List<Object> results = this.loader.getRowsFromResultSet(rs, queryParameters, session, returnProxies, forcedResultTransformer, maxRows, hydratedObjects, subselectResultKeys);
        return this.reactiveInitializeEntitiesAndCollections(hydratedObjects, rs, session, queryParameters.isReadOnly(session), afterLoadActionList).thenAccept(v -> {
            if (createSubselects) {
                this.loader.createSubselects(subselectResultKeys, queryParameters, session);
            }
        }).thenApply(v -> results);
    }

    private CompletionStage<Void> reactiveInitializeEntitiesAndCollections(List<Object> hydratedObjects, Object resultSetId, SharedSessionContractImplementor session, boolean readOnly, List<AfterLoadAction> afterLoadActions) throws HibernateException {
        CompletionStage<Void> stage;
        PostLoadEvent post;
        PreLoadEvent pre;
        CollectionPersister[] collectionPersisters = this.loader.getCollectionPersisters();
        if (collectionPersisters != null) {
            for (CollectionPersister collectionPersister : collectionPersisters) {
                if (!collectionPersister.isArray()) continue;
                this.loader.endCollectionLoad(resultSetId, session, collectionPersister);
            }
        }
        if (session.isEventSource()) {
            pre = new PreLoadEvent((EventSource)session);
            post = new PostLoadEvent((EventSource)session);
        } else {
            pre = null;
            post = null;
        }
        if (hydratedObjects != null && !hydratedObjects.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                long hydratedObjectsSize = hydratedObjects.stream().filter(Objects::nonNull).count();
                LOG.tracev("Total objects hydrated: {0}", hydratedObjectsSize);
            }
            stage = CompletionStages.loop(hydratedObjects, hydratedObject -> this.initializeEntity(hydratedObject, readOnly, session, pre));
        } else {
            stage = CompletionStages.voidFuture();
        }
        return stage.thenAccept(v -> {
            if (collectionPersisters != null) {
                for (CollectionPersister collectionPersister : collectionPersisters) {
                    if (collectionPersister.isArray()) continue;
                    this.loader.endCollectionLoad(resultSetId, session, collectionPersister);
                }
            }
            if (hydratedObjects != null) {
                for (Object hydratedObject : hydratedObjects) {
                    if (hydratedObject == null) continue;
                    TwoPhaseLoad.afterInitialize(hydratedObject, (SharedSessionContractImplementor)session);
                }
            }
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            if (hydratedObjects != null && !hydratedObjects.isEmpty()) {
                for (Object hydratedObject : hydratedObjects) {
                    if (hydratedObject == null) continue;
                    TwoPhaseLoad.postLoad(hydratedObject, (SharedSessionContractImplementor)session, (PostLoadEvent)post);
                    if (afterLoadActions == null) continue;
                    for (AfterLoadAction afterLoadAction : afterLoadActions) {
                        EntityEntry entityEntry = persistenceContext.getEntry(hydratedObject);
                        if (entityEntry == null) {
                            throw LOG.couldNotLocateEntityEntryAfterTwoPhaseLoad();
                        }
                        Loadable persister = (Loadable)entityEntry.getPersister();
                        afterLoadAction.afterLoad(session, hydratedObject, persister);
                    }
                }
            }
        });
    }
}

