/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.JDBCException;
import org.hibernate.dialect.PostgreSQL9Dialect;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.dialect.pagination.NoopLimitHandler;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.spi.AfterLoadAction;
import org.hibernate.reactive.adaptor.impl.QueryParametersAdaptor;
import org.hibernate.reactive.engine.impl.ReactivePersistenceContextAdapter;
import org.hibernate.reactive.loader.ReactiveResultSetProcessor;
import org.hibernate.reactive.pool.impl.Parameters;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.transform.ResultTransformer;

public interface ReactiveLoader {
    default public boolean isPostgresSQL(SharedSessionContractImplementor session) {
        return session.getJdbcServices().getDialect() instanceof PostgreSQL9Dialect;
    }

    default public CompletionStage<List<Object>> doReactiveQueryAndInitializeNonLazyCollections(String sql, SharedSessionContractImplementor session, QueryParameters queryParameters) {
        return this.doReactiveQueryAndInitializeNonLazyCollections(sql, session, queryParameters, false, null);
    }

    default public CompletionStage<List<Object>> doReactiveQueryAndInitializeNonLazyCollections(String sql, SharedSessionContractImplementor session, QueryParameters queryParameters, boolean returnProxies, ResultTransformer forcedResultTransformer) {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        boolean defaultReadOnlyOrig = persistenceContext.isDefaultReadOnly();
        if (queryParameters.isReadOnlyInitialized()) {
            persistenceContext.setDefaultReadOnly(queryParameters.isReadOnly());
        } else {
            queryParameters.setReadOnly(persistenceContext.isDefaultReadOnly());
        }
        persistenceContext.beforeLoad();
        ArrayList<AfterLoadAction> afterLoadActions = new ArrayList<AfterLoadAction>();
        return this.executeReactiveQueryStatement(sql, queryParameters, afterLoadActions, session).thenCompose(resultSet -> {
            this.discoverTypes(queryParameters, (ResultSet)resultSet);
            return this.reactiveProcessResultSet((ResultSet)resultSet, queryParameters, session, returnProxies, forcedResultTransformer, (List<AfterLoadAction>)afterLoadActions);
        }).whenComplete((list, e) -> persistenceContext.afterLoad()).thenCompose(list -> ((ReactivePersistenceContextAdapter)persistenceContext).reactiveInitializeNonLazyCollections().thenApply(v -> list)).whenComplete((list, e) -> persistenceContext.setDefaultReadOnly(defaultReadOnlyOrig));
    }

    public Parameters parameters();

    default public CompletionStage<ResultSet> executeReactiveQueryStatement(String sqlStatement, QueryParameters queryParameters, List<AfterLoadAction> afterLoadActions, SharedSessionContractImplementor session) {
        queryParameters.processFilters(sqlStatement, session);
        LimitHandler limitHandler = this.limitHandler(queryParameters.getRowSelection(), session);
        String sql = limitHandler.processSql(queryParameters.getFilteredSQL(), queryParameters.getRowSelection());
        sql = this.preprocessSQL(sql, queryParameters, session.getFactory(), afterLoadActions);
        Object[] parameterArray = this.toParameterArray(queryParameters, session, limitHandler);
        boolean hasFilter = session.getLoadQueryInfluencers().hasEnabledFilters();
        if (hasFilter) {
            sql = this.parameters().process(sql);
        } else if (LimitHelper.useLimit((LimitHandler)limitHandler, (RowSelection)queryParameters.getRowSelection())) {
            sql = this.parameters().processLimit(sql, parameterArray, LimitHelper.hasFirstRow((RowSelection)queryParameters.getRowSelection()));
        }
        return ((ReactiveConnectionSupplier)session).getReactiveConnection().selectJdbc(sql, parameterArray);
    }

    default public LimitHandler limitHandler(RowSelection selection, SharedSessionContractImplementor session) {
        LimitHandler limitHandler = session.getJdbcServices().getDialect().getLimitHandler();
        return LimitHelper.useLimit((LimitHandler)limitHandler, (RowSelection)selection) ? limitHandler : NoopLimitHandler.INSTANCE;
    }

    default public CompletionStage<List<Object>> reactiveProcessResultSet(ResultSet rs, QueryParameters queryParameters, SharedSessionContractImplementor session, boolean returnProxies, ResultTransformer forcedResultTransformer, List<AfterLoadAction> afterLoadActions) {
        try {
            return this.getReactiveResultSetProcessor().reactiveExtractResults(rs, session, queryParameters, null, returnProxies, queryParameters.isReadOnly(session), forcedResultTransformer, afterLoadActions);
        }
        catch (SQLException sqle) {
            throw new JDBCException("could not load batch", sqle);
        }
    }

    public ReactiveResultSetProcessor getReactiveResultSetProcessor();

    default public String preprocessSQL(String sql, QueryParameters queryParameters, SessionFactoryImplementor factory, List<AfterLoadAction> afterLoadActions) {
        return sql;
    }

    default public void discoverTypes(QueryParameters queryParameters, ResultSet resultSet) {
    }

    default public Object[] toParameterArray(QueryParameters queryParameters, SharedSessionContractImplementor session, LimitHandler limitHandler) {
        return QueryParametersAdaptor.arguments(queryParameters, session, limitHandler);
    }
}

