/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.hibernate.HibernateException;
import org.hibernate.QueryException;
import org.hibernate.cache.spi.FilterKey;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.event.impl.UnexpectedAccessToTheDatabase;
import org.hibernate.reactive.loader.ReactiveLoader;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.transform.CacheableResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.Type;

public interface CachingReactiveLoader<T>
extends ReactiveLoader {
    public static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    default public CompletionStage<List<Object>> doReactiveList(String sql, String queryIdentifier, SharedSessionContractImplementor session, QueryParameters queryParameters, ResultTransformer forcedResultTransformer) throws HibernateException {
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        boolean stats = statistics.isStatisticsEnabled();
        long startTime = stats ? System.nanoTime() : 0L;
        return this.doReactiveQueryAndInitializeNonLazyCollections(sql, session, queryParameters, true, forcedResultTransformer).handle((list, err) -> {
            CompletionStages.logSqlException(err, () -> "could not execute query", sql);
            if (err == null && stats) {
                long endTime = System.nanoTime();
                long milliseconds = TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
                statistics.queryExecuted(queryIdentifier, list.size(), milliseconds);
            }
            return CompletionStages.returnOrRethrow(err, list);
        });
    }

    default public CompletionStage<List<T>> reactiveListIgnoreQueryCache(String sql, String queryIdentifier, SharedSessionContractImplementor session, QueryParameters queryParameters) {
        return this.doReactiveList(sql, queryIdentifier, session, queryParameters, null).thenApply(result -> this.getResultList((List<?>)result, queryParameters.getResultTransformer()));
    }

    default public CompletionStage<List<T>> reactiveListUsingQueryCache(String sql, String queryIdentifier, SharedSessionContractImplementor session, QueryParameters queryParameters, Set<Serializable> querySpaces, Type[] resultTypes) {
        List<Object> cachedList;
        QueryResultsCache queryCache = session.getFactory().getCache().getQueryResultsCache(queryParameters.getCacheRegion());
        QueryKey key = this.queryKey(sql, session, queryParameters);
        try {
            cachedList = this.getReactiveResultFromQueryCache(session, queryParameters, querySpaces, resultTypes, queryCache, key);
        }
        catch (UnexpectedAccessToTheDatabase e) {
            LOG.debugf("Some of the entities are not in the cache. The cache will be ignored for query: %s ", sql);
            return this.reactiveListIgnoreQueryCache(sql, queryIdentifier, session, queryParameters);
        }
        CompletionStage<List<Object>> list = cachedList == null ? this.doReactiveList(sql, queryIdentifier, session, queryParameters, (ResultTransformer)key.getResultTransformer()).thenApply(cachableList -> {
            this.putReactiveResultInQueryCache(session, queryParameters, resultTypes, queryCache, key, (List<Object>)cachableList);
            return cachableList;
        }) : CompletionStages.completedFuture(cachedList);
        return list.thenApply(result -> this.getResultList(this.transform(queryParameters, key, (List<Object>)result, this.resolveResultTransformer(queryParameters.getResultTransformer())), queryParameters.getResultTransformer()));
    }

    default public List<?> transform(QueryParameters queryParameters, QueryKey key, List<Object> result, ResultTransformer resolvedTransformer) {
        if (resolvedTransformer == null) {
            return result;
        }
        CacheableResultTransformer transformer = key.getResultTransformer();
        if (this.areResultSetRowsTransformedImmediately()) {
            return transformer.retransformResults(result, this.getResultRowAliases(), queryParameters.getResultTransformer(), this.includeInResultRow());
        }
        return transformer.untransformToTuples(result);
    }

    default public QueryKey queryKey(String sql, SharedSessionContractImplementor session, QueryParameters queryParameters) {
        return QueryKey.generateQueryKey((String)sql, (QueryParameters)queryParameters, (Set)FilterKey.createFilterKeys((Map)session.getLoadQueryInfluencers().getEnabledFilters()), (SharedSessionContractImplementor)session, (CacheableResultTransformer)this.cacheableResultTransformer(queryParameters));
    }

    default public CacheableResultTransformer cacheableResultTransformer(QueryParameters queryParameters) {
        return CacheableResultTransformer.create((ResultTransformer)queryParameters.getResultTransformer(), (String[])this.getResultRowAliases(), (boolean[])this.includeInResultRow());
    }

    public boolean[] includeInResultRow();

    public List<Object> getReactiveResultFromQueryCache(SharedSessionContractImplementor var1, QueryParameters var2, Set<Serializable> var3, Type[] var4, QueryResultsCache var5, QueryKey var6);

    public void putReactiveResultInQueryCache(SharedSessionContractImplementor var1, QueryParameters var2, Type[] var3, QueryResultsCache var4, QueryKey var5, List<Object> var6);

    public ResultTransformer resolveResultTransformer(ResultTransformer var1);

    public String[] getResultRowAliases();

    public boolean areResultSetRowsTransformedImmediately();

    public List<T> getResultList(List<?> var1, ResultTransformer var2) throws QueryException;

    @Override
    default public Object[] toParameterArray(QueryParameters queryParameters, SharedSessionContractImplementor session, LimitHandler limitHandler) {
        return PreparedStatementAdaptor.bind(adaptor -> this.bindToPreparedStatement(adaptor, queryParameters, limitHandler, session));
    }

    public void bindToPreparedStatement(PreparedStatement var1, QueryParameters var2, LimitHandler var3, SharedSessionContractImplementor var4) throws SQLException;
}

