/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.id.impl;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.id.Configurable;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.reactive.id.impl.BlockingIdentifierGenerator;
import org.hibernate.reactive.id.impl.IdentifierGeneration;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;

public class SequenceReactiveIdentifierGenerator
extends BlockingIdentifierGenerator
implements Configurable {
    public static final Object[] NO_PARAMS = new Object[0];
    private String sql;
    private int increment;

    @Override
    protected int getBlockSize() {
        return this.increment;
    }

    @Override
    protected CompletionStage<Long> nextHiValue(ReactiveConnectionSupplier session) {
        return session.getReactiveConnection().selectIdentifier(this.sql, NO_PARAMS, Long.class).thenApply(this::next);
    }

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) {
        JdbcEnvironment jdbcEnvironment = (JdbcEnvironment)serviceRegistry.getService(JdbcEnvironment.class);
        Dialect dialect = jdbcEnvironment.getDialect();
        QualifiedName qualifiedSequenceName = IdentifierGeneration.determineSequenceName(params, serviceRegistry);
        String renderedSequenceName = jdbcEnvironment.getQualifiedObjectNameFormatter().format(qualifiedSequenceName, dialect);
        this.increment = this.determineIncrementForSequenceEmulation(params);
        this.sql = dialect.getSequenceNextValString(renderedSequenceName);
    }

    protected int determineIncrementForSequenceEmulation(Properties params) {
        return ConfigurationHelper.getInt((String)"increment_size", (Map)params, (int)1);
    }
}

