/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.id.impl;

import java.lang.invoke.MethodHandles;
import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.SelectGenerator;
import org.hibernate.id.SequenceGenerator;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.SequenceStructure;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.enhanced.TableGenerator;
import org.hibernate.id.enhanced.TableStructure;
import org.hibernate.id.factory.internal.DefaultIdentifierGeneratorFactory;
import org.hibernate.reactive.id.ReactiveIdentifierGenerator;
import org.hibernate.reactive.id.impl.EmulatedSequenceReactiveIdentifierGenerator;
import org.hibernate.reactive.id.impl.ReactiveGeneratorWrapper;
import org.hibernate.reactive.id.impl.SequenceReactiveIdentifierGenerator;
import org.hibernate.reactive.id.impl.TableReactiveIdentifierGenerator;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.Type;

public class ReactiveIdentifierGeneratorFactory
extends DefaultIdentifierGeneratorFactory {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private ServiceRegistryImplementor serviceRegistry;

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        super.injectServices(serviceRegistry);
        this.serviceRegistry = serviceRegistry;
    }

    public IdentifierGenerator createIdentifierGenerator(String strategy, Type type, Properties config) {
        ReactiveGeneratorWrapper result;
        Object generator;
        try {
            Class clazz = this.getIdentifierGeneratorClass(strategy);
            generator = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            String entityName = config.getProperty("entity_name");
            throw new MappingException(String.format("Could not instantiate id generator [entity-name=%s]", entityName), (Throwable)e);
        }
        if (generator instanceof Configurable) {
            ((Configurable)generator).configure(type, config, (ServiceRegistry)this.serviceRegistry);
        }
        if (generator instanceof IdentifierGenerator) {
            result = ReactiveIdentifierGeneratorFactory.augmentWithReactiveGenerator((IdentifierGenerator)generator, type, config, this.serviceRegistry);
        } else if (generator instanceof ReactiveIdentifierGenerator) {
            result = new ReactiveGeneratorWrapper((ReactiveIdentifierGenerator)generator);
        } else {
            String entityName = config.getProperty("entity_name");
            throw new MappingException(String.format("Not an id generator [entity-name=%s]", entityName));
        }
        result.configure(type, config, (ServiceRegistry)this.serviceRegistry);
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IdentifierGenerator augmentWithReactiveGenerator(IdentifierGenerator generator, Type type, Properties params, ServiceRegistryImplementor serviceRegistry) {
        void var4_10;
        String catalog;
        String schema;
        if (generator instanceof SequenceStyleGenerator) {
            DatabaseStructure structure = ((SequenceStyleGenerator)generator).getDatabaseStructure();
            if (structure instanceof TableStructure) {
                EmulatedSequenceReactiveIdentifierGenerator emulatedSequenceReactiveIdentifierGenerator = new EmulatedSequenceReactiveIdentifierGenerator();
            } else {
                if (!(structure instanceof SequenceStructure)) throw LOG.unknownStructureType();
                SequenceReactiveIdentifierGenerator sequenceReactiveIdentifierGenerator = new SequenceReactiveIdentifierGenerator();
            }
        } else if (generator instanceof TableGenerator) {
            TableReactiveIdentifierGenerator tableReactiveIdentifierGenerator = new TableReactiveIdentifierGenerator();
        } else if (generator instanceof SequenceGenerator) {
            SequenceReactiveIdentifierGenerator sequenceReactiveIdentifierGenerator = new SequenceReactiveIdentifierGenerator();
        } else {
            if (!(generator instanceof SelectGenerator)) return generator;
            throw LOG.selectGeneratorIsNotSupportedInHibernateReactive();
        }
        ConfigurationService cs = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
        if (!params.containsKey("schema") && (schema = (String)cs.getSetting("hibernate.default_schema", StandardConverters.STRING)) != null) {
            params.put("schema", schema);
        }
        if (!params.containsKey("catalog") && (catalog = (String)cs.getSetting("hibernate.default_catalog", StandardConverters.STRING)) != null) {
            params.put("catalog", catalog);
        }
        ((Configurable)var4_10).configure(type, params, (ServiceRegistry)serviceRegistry);
        return new ReactiveGeneratorWrapper(var4_10, generator);
    }
}

