/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.id.impl;

import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.ExportableProducer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.reactive.id.ReactiveIdentifierGenerator;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;

public class ReactiveGeneratorWrapper<T>
implements IdentifierGenerator,
ExportableProducer,
ReactiveIdentifierGenerator<T> {
    private ReactiveIdentifierGenerator<T> reactiveGenerator;
    private IdentifierGenerator generator;

    public ReactiveGeneratorWrapper(ReactiveIdentifierGenerator<T> reactiveGenerator, IdentifierGenerator generator) {
        this.reactiveGenerator = reactiveGenerator;
        this.generator = generator;
    }

    public ReactiveGeneratorWrapper(ReactiveIdentifierGenerator<T> reactiveGenerator) {
        this.reactiveGenerator = reactiveGenerator;
    }

    @Override
    public CompletionStage<T> generate(ReactiveConnectionSupplier session, Object entity) {
        return this.reactiveGenerator.generate(session, entity);
    }

    public Serializable generate(SharedSessionContractImplementor session, Object object) {
        if (this.generator == null) {
            throw new UnsupportedOperationException("reactive generator");
        }
        return this.generator.generate(session, object);
    }

    public void registerExportables(Database database) {
        if (this.generator != null) {
            this.generator.registerExportables(database);
        }
        if (this.reactiveGenerator instanceof ExportableProducer) {
            ((ExportableProducer)this.reactiveGenerator).registerExportables(database);
        }
    }
}

