/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.id.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedNameParser;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.id.ReactiveIdentifierGenerator;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.ShortType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;

public class IdentifierGeneration {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    static QualifiedName determineSequenceName(Properties params, ServiceRegistry serviceRegistry) {
        String defaultSequenceName;
        String sequenceName;
        String generatorName;
        String sequencePerEntitySuffix = ConfigurationHelper.getString((String)"sequence_per_entity_suffix", (Map)params, (String)"_SEQ");
        String fallbackSequenceName = "hibernate_sequence";
        if (IdentifierGeneration.preferGeneratorNameAsDefaultName(serviceRegistry).booleanValue() && StringHelper.isNotEmpty((String)(generatorName = params.getProperty("GENERATOR_NAME")))) {
            fallbackSequenceName = generatorName;
        }
        if ((sequenceName = ConfigurationHelper.getString((String)"sequence_name", (Map)params, (String)(defaultSequenceName = ConfigurationHelper.getBoolean((String)"prefer_sequence_per_entity", (Map)params, (boolean)false) ? params.getProperty("jpa_entity_name") + sequencePerEntitySuffix : fallbackSequenceName))).contains(".")) {
            return QualifiedNameParser.INSTANCE.parse(sequenceName);
        }
        JdbcEnvironment jdbcEnvironment = (JdbcEnvironment)serviceRegistry.getService(JdbcEnvironment.class);
        Identifier catalog = jdbcEnvironment.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString((String)"catalog", (Map)params));
        Identifier schema = jdbcEnvironment.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString((String)"schema", (Map)params));
        return new QualifiedNameParser.NameParts(catalog, schema, jdbcEnvironment.getIdentifierHelper().toIdentifier(sequenceName));
    }

    static QualifiedName determineTableName(Properties params, ServiceRegistry serviceRegistry) {
        QualifiedNameParser.NameParts qualifiedTableName;
        String tableName;
        String generatorName;
        String fallbackTableName = "hibernate_sequences";
        if (IdentifierGeneration.preferGeneratorNameAsDefaultName(serviceRegistry).booleanValue() && StringHelper.isNotEmpty((String)(generatorName = params.getProperty("GENERATOR_NAME")))) {
            fallbackTableName = generatorName;
        }
        if ((tableName = ConfigurationHelper.getString((String)"table_name", (Map)params, (String)fallbackTableName)).contains(".")) {
            qualifiedTableName = QualifiedNameParser.INSTANCE.parse(tableName);
        } else {
            JdbcEnvironment jdbcEnvironment = (JdbcEnvironment)serviceRegistry.getService(JdbcEnvironment.class);
            Identifier catalog = jdbcEnvironment.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString((String)"catalog", (Map)params));
            Identifier schema = jdbcEnvironment.getIdentifierHelper().toIdentifier(ConfigurationHelper.getString((String)"schema", (Map)params));
            qualifiedTableName = new QualifiedNameParser.NameParts(catalog, schema, jdbcEnvironment.getIdentifierHelper().toIdentifier(tableName));
        }
        return qualifiedTableName;
    }

    private static Boolean preferGeneratorNameAsDefaultName(ServiceRegistry serviceRegistry) {
        return (Boolean)((ConfigurationService)serviceRegistry.getService(ConfigurationService.class)).getSetting("hibernate.model.generator_name_as_sequence_name", StandardConverters.BOOLEAN, (Object)true);
    }

    public static CompletionStage<Serializable> generateId(Object entity, EntityPersister persister, ReactiveConnectionSupplier connectionSupplier, SharedSessionContractImplementor session) {
        IdentifierGenerator generator = persister.getIdentifierGenerator();
        return generator instanceof ReactiveIdentifierGenerator ? ((ReactiveIdentifierGenerator)generator).generate(connectionSupplier, entity) : CompletionStages.completedFuture(generator.generate(session, entity));
    }

    public static Serializable assignIdIfNecessary(Object generatedId, Object entity, EntityPersister persister, SharedSessionContractImplementor session) {
        if (generatedId != null) {
            return IdentifierGeneration.castToIdentifierType(generatedId, persister);
        }
        Serializable assignedId = persister.getIdentifier(entity, session);
        if (assignedId == null) {
            throw new IdentifierGenerationException("ids for this class must be manually assigned before calling save(): " + persister.getEntityName());
        }
        return assignedId;
    }

    public static Serializable castToIdentifierType(Object generatedId, EntityPersister persister) {
        if (generatedId instanceof Long) {
            Long longId = (Long)generatedId;
            if (longId <= 0L) {
                throw LOG.generatedIdentifierSmallerOrEqualThanZero(longId);
            }
            Type identifierType = persister.getIdentifierType();
            if (identifierType == LongType.INSTANCE) {
                return longId;
            }
            if (identifierType == IntegerType.INSTANCE) {
                IdentifierGeneration.validateMaxValue(persister, longId, Integer.MAX_VALUE);
                return Integer.valueOf(longId.intValue());
            }
            if (identifierType == ShortType.INSTANCE) {
                IdentifierGeneration.validateMaxValue(persister, longId, Short.MAX_VALUE);
                return Short.valueOf(longId.shortValue());
            }
            if (identifierType == StringType.INSTANCE) {
                return longId.toString();
            }
            throw LOG.cannotGenerateIdentifiersOfType(identifierType.getReturnedClass().getSimpleName(), persister.getEntityName());
        }
        return (Serializable)generatedId;
    }

    private static void validateMaxValue(EntityPersister persister, Long id, int maxValue) {
        if (id > (long)maxValue) {
            throw LOG.generatedIdentifierTooBigForTheField(persister.getEntityName(), persister.getIdentifierType().getReturnedClass().getSimpleName(), id);
        }
    }
}

