/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.id.impl;

import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.reactive.id.impl.IdentifierGeneration;
import org.hibernate.reactive.id.impl.TableReactiveIdentifierGenerator;
import org.hibernate.service.ServiceRegistry;

public class EmulatedSequenceReactiveIdentifierGenerator
extends TableReactiveIdentifierGenerator {
    @Override
    protected Boolean determineStoreLastUsedValue(ServiceRegistry serviceRegistry) {
        return false;
    }

    @Override
    protected QualifiedName determineTableName(Properties params, ServiceRegistry serviceRegistry) {
        return IdentifierGeneration.determineSequenceName(params, serviceRegistry);
    }

    @Override
    protected String determineValueColumnNameForTable(Properties params, JdbcEnvironment jdbcEnvironment) {
        String name = ConfigurationHelper.getString((String)"value_column", (Map)params, (String)"next_val");
        return jdbcEnvironment.getIdentifierHelper().toIdentifier(name).render(jdbcEnvironment.getDialect());
    }

    @Override
    protected String determineSegmentColumnName(Properties params, JdbcEnvironment jdbcEnvironment) {
        return null;
    }

    @Override
    protected String determineSegmentValue(Properties params) {
        return null;
    }

    @Override
    protected int determineInitialValue(Properties params) {
        return ConfigurationHelper.getInt((String)"initial_value", (Map)params, (int)1);
    }

    @Override
    protected int determineIncrement(Properties params) {
        return ConfigurationHelper.getInt((String)"increment_size", (Map)params, (int)1);
    }

    @Override
    protected Object[] updateParameters(long currentValue, long updatedValue) {
        return new Object[]{updatedValue, currentValue};
    }

    @Override
    protected Object[] insertParameters(long insertedValue) {
        return new Object[]{insertedValue};
    }

    @Override
    protected Object[] selectParameters() {
        return new Object[0];
    }

    @Override
    protected String buildSelectQuery() {
        return "select tbl." + this.valueColumnName + " from " + this.renderedTableName + " tbl";
    }

    @Override
    protected String buildUpdateQuery() {
        return "update " + this.renderedTableName + " set " + this.valueColumnName + "=? where " + this.valueColumnName + "=?";
    }

    @Override
    protected String buildInsertQuery() {
        return "insert into " + this.renderedTableName + " (" + this.valueColumnName + ")  values (?)";
    }
}

