/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.id.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.reactive.id.ReactiveIdentifierGenerator;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.util.impl.CompletionStages;

public abstract class BlockingIdentifierGenerator
implements ReactiveIdentifierGenerator<Long> {
    private int loValue;
    private long hiValue;
    private volatile List<Runnable> queue = null;

    protected abstract int getBlockSize();

    protected abstract CompletionStage<Long> nextHiValue(ReactiveConnectionSupplier var1);

    protected synchronized long next() {
        return this.loValue > 0 && this.loValue < this.getBlockSize() ? this.hiValue + (long)this.loValue++ : -1L;
    }

    protected synchronized long next(long hi) {
        this.hiValue = hi;
        this.loValue = 1;
        return hi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Long> generate(ReactiveConnectionSupplier session, Object entity) {
        if (this.getBlockSize() <= 1) {
            return this.nextHiValue(session);
        }
        long local = this.next();
        if (local >= 0L) {
            return CompletionStages.completedFuture(local);
        }
        BlockingIdentifierGenerator blockingIdentifierGenerator = this;
        synchronized (blockingIdentifierGenerator) {
            CompletableFuture<Long> result = new CompletableFuture<Long>();
            if (this.queue == null) {
                this.queue = new ArrayList<Runnable>();
                this.nextHiValue(session).thenAccept(id -> {
                    List<Runnable> list;
                    BlockingIdentifierGenerator blockingIdentifierGenerator = this;
                    synchronized (blockingIdentifierGenerator) {
                        list = this.queue;
                        this.queue = null;
                        result.complete(this.next((long)id));
                    }
                    list.forEach(Runnable::run);
                });
            } else {
                this.queue.add(() -> this.generate(session, entity).thenAccept(result::complete));
            }
            return result;
        }
    }
}

