/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.event.impl;

import org.hibernate.AssertionFailure;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.jpa.event.spi.CallbackRegistry;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;
import org.hibernate.reactive.engine.impl.ReactiveEntityIncrementVersionProcess;
import org.hibernate.reactive.engine.impl.ReactiveEntityVerifyVersionProcess;
import org.hibernate.reactive.session.ReactiveSession;

public class DefaultReactivePostLoadEventListener
implements PostLoadEventListener,
CallbackRegistryConsumer {
    private CallbackRegistry callbackRegistry;

    public void injectCallbackRegistry(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    public void onPostLoad(PostLoadEvent event) {
        Object entity = event.getEntity();
        this.callbackRegistry.postLoad(entity);
        EventSource session = event.getSession();
        EntityEntry entry = session.getPersistenceContextInternal().getEntry(entity);
        if (entry == null) {
            throw new AssertionFailure("possible non-threadsafe access to the session");
        }
        LockMode lockMode = entry.getLockMode();
        if (LockMode.OPTIMISTIC_FORCE_INCREMENT.equals((Object)lockMode)) {
            ((ReactiveSession)session).getReactiveActionQueue().registerProcess(new ReactiveEntityIncrementVersionProcess(entity));
        } else if (LockMode.OPTIMISTIC.equals((Object)lockMode)) {
            ((ReactiveSession)session).getReactiveActionQueue().registerProcess(new ReactiveEntityVerifyVersionProcess(entity));
        }
    }
}

