/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.event.impl;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.PersistentObjectException;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.EntityState;
import org.hibernate.event.internal.EventUtil;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PersistEvent;
import org.hibernate.event.spi.PersistEventListener;
import org.hibernate.id.ForeignGenerator;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.reactive.engine.impl.CascadingAction;
import org.hibernate.reactive.engine.impl.CascadingActions;
import org.hibernate.reactive.event.ReactivePersistEventListener;
import org.hibernate.reactive.event.impl.AbstractReactiveSaveEventListener;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.util.impl.CompletionStages;

public class DefaultReactivePersistEventListener
extends AbstractReactiveSaveEventListener<IdentitySet>
implements PersistEventListener,
ReactivePersistEventListener,
CallbackRegistryConsumer {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    @Override
    protected CascadingAction<IdentitySet> getCascadeReactiveAction() {
        return CascadingActions.PERSIST;
    }

    @Override
    public CompletionStage<Void> reactiveOnPersist(PersistEvent event) throws HibernateException {
        return this.reactiveOnPersist(event, new IdentitySet(10));
    }

    @Override
    public CompletionStage<Void> reactiveOnPersist(PersistEvent event, IdentitySet createCache) throws HibernateException {
        EntityPersister persister;
        String entityName;
        Object entity;
        EventSource source = event.getSession();
        Object object = event.getObject();
        if (object instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                if (li.getSession() == source) {
                    return CompletionStages.voidFuture();
                }
                return CompletionStages.failedFuture((Throwable)new PersistentObjectException("uninitialized proxy passed to persist()"));
            }
            entity = li.getImplementation();
        } else {
            entity = object;
        }
        if (event.getEntityName() != null) {
            entityName = event.getEntityName();
        } else {
            entityName = source.bestGuessEntityName(entity);
            event.setEntityName(entityName);
        }
        EntityEntry entityEntry = source.getPersistenceContextInternal().getEntry(entity);
        EntityState entityState = EntityState.getEntityState((Object)entity, (String)entityName, (EntityEntry)entityEntry, (SessionImplementor)source, (Boolean)true);
        if (entityState == EntityState.DETACHED && (persister = source.getFactory().getMetamodel().entityPersister(entityName)).getIdentifierGenerator() instanceof ForeignGenerator) {
            if (LOG.isDebugEnabled() && persister.getIdentifier(entity, (SharedSessionContractImplementor)source) != null) {
                LOG.debug("Resetting entity id attribute to null for foreign generator");
            }
            persister.setIdentifier(entity, null, (SharedSessionContractImplementor)source);
            entityState = EntityState.getEntityState((Object)entity, (String)entityName, (EntityEntry)entityEntry, (SessionImplementor)source, (Boolean)true);
        }
        switch (entityState) {
            case DETACHED: {
                return CompletionStages.failedFuture((Throwable)new PersistentObjectException("detached entity passed to persist: " + EventUtil.getLoggableName((String)event.getEntityName(), (Object)entity)));
            }
            case PERSISTENT: {
                return this.entityIsPersistent(event, createCache);
            }
            case TRANSIENT: {
                return this.entityIsTransient(event, createCache);
            }
            case DELETED: {
                entityEntry.setStatus(Status.MANAGED);
                entityEntry.setDeletedState(null);
                event.getSession().getActionQueue().unScheduleDeletion(entityEntry, event.getObject());
                return this.entityIsDeleted(event, createCache);
            }
        }
        return CompletionStages.failedFuture((Throwable)new ObjectDeletedException("deleted entity passed to persist", null, EventUtil.getLoggableName((String)event.getEntityName(), (Object)entity)));
    }

    protected CompletionStage<Void> entityIsPersistent(PersistEvent event, IdentitySet createCache) {
        LOG.trace("Ignoring persistent instance");
        EventSource source = event.getSession();
        Object entity = source.getPersistenceContextInternal().unproxy(event.getObject());
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        return createCache.add(entity) ? this.justCascade(createCache, source, entity, persister) : CompletionStages.voidFuture();
    }

    private CompletionStage<Void> justCascade(IdentitySet createCache, EventSource source, Object entity, EntityPersister persister) {
        return this.cascadeBeforeSave(source, persister, entity, createCache).thenCompose(v -> this.cascadeAfterSave(source, persister, entity, createCache));
    }

    protected CompletionStage<Void> entityIsTransient(PersistEvent event, IdentitySet createCache) {
        LOG.trace("Saving transient instance");
        EventSource source = event.getSession();
        Object entity = source.getPersistenceContextInternal().unproxy(event.getObject());
        return createCache.add(entity) ? this.reactiveSaveWithGeneratedId(entity, event.getEntityName(), createCache, source, false) : CompletionStages.voidFuture();
    }

    private CompletionStage<Void> entityIsDeleted(PersistEvent event, IdentitySet createCache) {
        EventSource source = event.getSession();
        Object entity = source.getPersistenceContextInternal().unproxy(event.getObject());
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        if (LOG.isTraceEnabled()) {
            LOG.tracef("un-scheduling entity deletion [%s]", MessageHelper.infoString((EntityPersister)persister, (Object)persister.getIdentifier(entity, (SharedSessionContractImplementor)source), (SessionFactoryImplementor)source.getFactory()));
        }
        return createCache.add(entity) ? this.justCascade(createCache, source, entity, persister) : CompletionStages.voidFuture();
    }

    public void onPersist(PersistEvent event) {
        throw new UnsupportedOperationException();
    }

    public void onPersist(PersistEvent event, Map createdAlready) {
        throw new UnsupportedOperationException();
    }
}

