/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.event.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.WrongClassException;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.internal.EntityState;
import org.hibernate.event.internal.EventUtil;
import org.hibernate.event.internal.MergeContext;
import org.hibernate.event.spi.EntityCopyObserver;
import org.hibernate.event.spi.EntityCopyObserverFactory;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.MergeEvent;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.reactive.engine.impl.Cascade;
import org.hibernate.reactive.engine.impl.CascadingAction;
import org.hibernate.reactive.engine.impl.CascadingActions;
import org.hibernate.reactive.engine.impl.EntityTypes;
import org.hibernate.reactive.event.ReactiveMergeEventListener;
import org.hibernate.reactive.event.impl.AbstractReactiveSaveEventListener;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;

public class DefaultReactiveMergeEventListener
extends AbstractReactiveSaveEventListener<MergeContext>
implements ReactiveMergeEventListener,
MergeEventListener {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public void onMerge(MergeEvent event) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    public void onMerge(MergeEvent event, Map copiedAlready) throws HibernateException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Map<?, ?> getMergeMap(Object anything) {
        return ((MergeContext)anything).invertMap();
    }

    @Override
    public CompletionStage<Void> reactiveOnMerge(MergeEvent event) throws HibernateException {
        EntityCopyObserver entityCopyObserver = this.createEntityCopyObserver(event.getSession().getFactory());
        MergeContext mergeContext = new MergeContext(event.getSession(), entityCopyObserver);
        return this.reactiveOnMerge(event, mergeContext).thenAccept(v -> entityCopyObserver.topLevelMergeComplete(event.getSession())).whenComplete((v, e) -> {
            entityCopyObserver.clear();
            mergeContext.clear();
        });
    }

    private EntityCopyObserver createEntityCopyObserver(SessionFactoryImplementor sessionFactory) {
        ServiceRegistryImplementor serviceRegistry = sessionFactory.getServiceRegistry();
        EntityCopyObserverFactory configurationService = (EntityCopyObserverFactory)serviceRegistry.getService(EntityCopyObserverFactory.class);
        return configurationService.createEntityCopyObserver();
    }

    @Override
    public CompletionStage<Void> reactiveOnMerge(MergeEvent event, MergeContext copyCache) throws HibernateException {
        EventSource source = event.getSession();
        Object original = event.getOriginal();
        if (original != null) {
            Object entity;
            if (original instanceof HibernateProxy) {
                LazyInitializer li = ((HibernateProxy)original).getHibernateLazyInitializer();
                if (li.isUninitialized()) {
                    LOG.trace("Ignoring uninitialized proxy");
                    event.setResult(source.load(li.getEntityName(), li.getIdentifier()));
                    return CompletionStages.voidFuture();
                }
                entity = li.getImplementation();
            } else if (original instanceof PersistentAttributeInterceptable) {
                PersistentAttributeInterceptable interceptable = (PersistentAttributeInterceptable)original;
                PersistentAttributeInterceptor interceptor = interceptable.$$_hibernate_getInterceptor();
                if (interceptor instanceof EnhancementAsProxyLazinessInterceptor) {
                    EnhancementAsProxyLazinessInterceptor proxyInterceptor = (EnhancementAsProxyLazinessInterceptor)interceptor;
                    LOG.trace("Ignoring uninitialized enhanced-proxy");
                    event.setResult(source.load(proxyInterceptor.getEntityName(), (Serializable)proxyInterceptor.getIdentifier()));
                    return CompletionStages.voidFuture();
                }
                entity = original;
            } else {
                entity = original;
            }
            if (copyCache.containsKey(entity) && copyCache.isOperatedOn(entity)) {
                LOG.trace("Already in merge process");
                event.setResult(entity);
            } else {
                EntityKey key;
                Object managedEntity;
                EntityPersister persister;
                Serializable id;
                if (copyCache.containsKey(entity)) {
                    LOG.trace("Already in copyCache; setting in merge process");
                    copyCache.setOperatedOn(entity, true);
                }
                event.setEntity(entity);
                EntityState entityState = null;
                PersistenceContext persistenceContext = source.getPersistenceContextInternal();
                EntityEntry entry = persistenceContext.getEntry(entity);
                if (entry == null && (id = (persister = source.getEntityPersister(event.getEntityName(), entity)).getIdentifier(entity, (SharedSessionContractImplementor)source)) != null && (entry = persistenceContext.getEntry(managedEntity = persistenceContext.getEntity(key = source.generateEntityKey(id, persister)))) != null) {
                    entityState = EntityState.DETACHED;
                }
                if (entityState == null) {
                    entityState = EntityState.getEntityState((Object)entity, (String)event.getEntityName(), (EntityEntry)entry, (SessionImplementor)source, (Boolean)false);
                }
                switch (entityState) {
                    case DETACHED: {
                        return this.entityIsDetached(event, copyCache);
                    }
                    case TRANSIENT: {
                        return this.entityIsTransient(event, copyCache);
                    }
                    case PERSISTENT: {
                        return this.entityIsPersistent(event, copyCache);
                    }
                }
                throw new ObjectDeletedException("deleted instance passed to merge", null, EventUtil.getLoggableName((String)event.getEntityName(), (Object)entity));
            }
        }
        return CompletionStages.voidFuture();
    }

    protected CompletionStage<Void> entityIsPersistent(MergeEvent event, MergeContext copyCache) {
        LOG.trace("Ignoring persistent instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        copyCache.put(entity, entity, true);
        return this.cascadeOnMerge(source, persister, entity, copyCache).thenCompose(v -> this.fetchAndCopyValues(persister, entity, entity, (SessionImplementor)source, copyCache)).thenAccept(v -> event.setResult(entity));
    }

    protected CompletionStage<Void> entityIsTransient(MergeEvent event, MergeContext copyCache) {
        Object copy;
        LOG.trace("Merging transient instance");
        Object entity = event.getEntity();
        EventSource session = event.getSession();
        String entityName = event.getEntityName();
        EntityPersister persister = session.getEntityPersister(entityName, entity);
        Serializable id = persister.hasIdentifierProperty() ? persister.getIdentifier(entity, (SharedSessionContractImplementor)session) : null;
        Object existingCopy = copyCache.get(entity);
        if (existingCopy != null) {
            persister.setIdentifier(copyCache.get(entity), id, (SharedSessionContractImplementor)session);
            copy = existingCopy;
        } else {
            copy = session.instantiate(persister, id);
            copyCache.put(entity, copy, true);
        }
        return super.cascadeBeforeSave(session, persister, entity, copyCache).thenCompose(v -> this.copyValues(persister, entity, copy, (SessionImplementor)session, copyCache, ForeignKeyDirection.FROM_PARENT)).thenCompose(v -> this.saveTransientEntity(copy, entityName, event.getRequestedId(), session, copyCache)).thenCompose(v -> super.cascadeAfterSave(session, persister, entity, copyCache)).thenCompose(v -> this.copyValues(persister, entity, copy, (SessionImplementor)session, copyCache, ForeignKeyDirection.TO_PARENT)).thenAccept(v -> {
            PersistentAttributeInterceptable interceptable;
            PersistentAttributeInterceptor interceptor;
            event.setResult(copy);
            if (copy instanceof PersistentAttributeInterceptable && (interceptor = (interceptable = (PersistentAttributeInterceptable)copy).$$_hibernate_getInterceptor()) == null) {
                persister.getBytecodeEnhancementMetadata().injectInterceptor(copy, (Object)id, (SharedSessionContractImplementor)session);
            }
        });
    }

    private CompletionStage<Void> saveTransientEntity(Object entity, String entityName, Serializable requestedId, EventSource source, MergeContext copyCache) {
        return requestedId == null ? this.reactiveSaveWithGeneratedId(entity, entityName, copyCache, source, false) : this.reactiveSaveWithRequestedId(entity, requestedId, entityName, copyCache, source);
    }

    protected CompletionStage<Void> entityIsDetached(MergeEvent event, MergeContext copyCache) {
        Serializable id;
        LOG.trace("Merging detached instance");
        Object entity = event.getEntity();
        EventSource source = event.getSession();
        EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
        String entityName = persister.getEntityName();
        Serializable requestedId = event.getRequestedId();
        if (requestedId == null) {
            id = persister.getIdentifier(entity, (SharedSessionContractImplementor)source);
        } else {
            id = requestedId;
            Serializable entityId = persister.getIdentifier(entity, (SharedSessionContractImplementor)source);
            if (!persister.getIdentifierType().isEqual((Object)id, (Object)entityId, source.getFactory())) {
                throw LOG.mergeRequestedIdNotMatchingIdOfPassedEntity();
            }
        }
        String previousFetchProfile = source.getLoadQueryInfluencers().getInternalFetchProfile();
        source.getLoadQueryInfluencers().setInternalFetchProfile("merge");
        Serializable clonedIdentifier = (Serializable)persister.getIdentifierType().deepCopy((Object)id, source.getFactory());
        return ((ReactiveSession)source.unwrap(ReactiveSession.class)).reactiveGet(persister.getMappedClass(), clonedIdentifier).thenCompose(result -> {
            if (result != null) {
                copyCache.put(entity, result, true);
                Object target = this.unproxyManagedForDetachedMerging(entity, result, persister, source);
                if (target == entity) {
                    throw new AssertionFailure("entity was not detached");
                }
                if (!source.getEntityName(target).equals(entityName)) {
                    throw new WrongClassException("class of the given object did not match class of persistent copy", event.getRequestedId(), entityName);
                }
                if (this.isVersionChanged(entity, source, persister, target)) {
                    StatisticsImplementor statistics = source.getFactory().getStatistics();
                    if (statistics.isStatisticsEnabled()) {
                        statistics.optimisticFailure(entityName);
                    }
                    throw new StaleObjectStateException(entityName, id);
                }
                return this.cascadeOnMerge(source, persister, entity, copyCache).thenCompose(v -> this.fetchAndCopyValues(persister, entity, target, (SessionImplementor)source, copyCache)).thenAccept(v -> {
                    this.markInterceptorDirty(entity, target, persister);
                    event.setResult(result);
                });
            }
            return this.entityIsTransient(event, copyCache);
        }).whenComplete((v, e) -> source.getLoadQueryInfluencers().setInternalFetchProfile(previousFetchProfile));
    }

    private Object unproxyManagedForDetachedMerging(Object incoming, Object managed, EntityPersister persister, EventSource source) {
        if (managed instanceof HibernateProxy) {
            return source.getPersistenceContextInternal().unproxy(managed);
        }
        if (incoming instanceof PersistentAttributeInterceptable && persister.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading()) {
            PersistentAttributeInterceptor incomingInterceptor = ((PersistentAttributeInterceptable)incoming).$$_hibernate_getInterceptor();
            PersistentAttributeInterceptor managedInterceptor = ((PersistentAttributeInterceptable)managed).$$_hibernate_getInterceptor();
            if (!(managedInterceptor instanceof EnhancementAsProxyLazinessInterceptor)) {
                return managed;
            }
            if (incomingInterceptor instanceof EnhancementAsProxyLazinessInterceptor) {
                return managed;
            }
            return persister.initializeEnhancedEntityUsedAsProxy(managed, null, (SharedSessionContractImplementor)source);
        }
        return managed;
    }

    private void markInterceptorDirty(Object entity, Object target, EntityPersister persister) {
        if (entity instanceof SelfDirtinessTracker && target instanceof SelfDirtinessTracker) {
            SelfDirtinessTracker entityTracker = (SelfDirtinessTracker)entity;
            SelfDirtinessTracker targetTracker = (SelfDirtinessTracker)target;
            targetTracker.$$_hibernate_clearDirtyAttributes();
            for (String fieldName : entityTracker.$$_hibernate_getDirtyAttributes()) {
                targetTracker.$$_hibernate_trackChange(fieldName);
            }
        }
    }

    private boolean isVersionChanged(Object entity, EventSource source, EntityPersister persister, Object target) {
        if (!persister.isVersioned()) {
            return false;
        }
        boolean changed = !persister.getVersionType().isSame(persister.getVersion(target), persister.getVersion(entity));
        return changed && this.existsInDatabase(target, source, persister);
    }

    private boolean existsInDatabase(Object entity, EventSource source, EntityPersister persister) {
        Serializable id;
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        EntityEntry entry = persistenceContext.getEntry(entity);
        if (entry == null && (id = persister.getIdentifier(entity, (SharedSessionContractImplementor)source)) != null) {
            EntityKey key = source.generateEntityKey(id, persister);
            Object managedEntity = persistenceContext.getEntity(key);
            entry = persistenceContext.getEntry(managedEntity);
        }
        return entry != null && entry.isExistsInDatabase();
    }

    private CompletionStage<Void> fetchAndCopyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, MergeContext mergeContext) {
        CompletionStage<Void> stage;
        if (entity == target) {
            stage = CompletionStages.voidFuture();
        } else {
            ReactiveSession session = (ReactiveSession)source.unwrap(ReactiveSession.class);
            Object[] mergeState = persister.getPropertyValues(entity);
            Object[] managedState = persister.getPropertyValues(target);
            stage = CompletionStages.loop(0, mergeState.length, i -> Hibernate.isInitialized((Object)mergeState[i]) && !Hibernate.isInitialized((Object)managedState[i]), i -> session.reactiveFetch(managedState[i], true));
        }
        return stage.thenCompose(v -> this.copyValues(persister, entity, target, source, mergeContext));
    }

    protected CompletionStage<Void> copyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, MergeContext copyCache) {
        return EntityTypes.replace(persister.getPropertyValues(entity), persister.getPropertyValues(target), persister.getPropertyTypes(), source, target, (Map)copyCache).thenAccept(copiedValues -> persister.setPropertyValues(target, copiedValues));
    }

    protected CompletionStage<Void> copyValues(EntityPersister persister, Object entity, Object target, SessionImplementor source, MergeContext copyCache, ForeignKeyDirection foreignKeyDirection) {
        if (foreignKeyDirection == ForeignKeyDirection.TO_PARENT) {
            Object[] copiedValues2 = TypeHelper.replaceAssociations((Object[])persister.getPropertyValues(entity), (Object[])persister.getPropertyValues(target), (Type[])persister.getPropertyTypes(), (SharedSessionContractImplementor)source, (Object)target, (Map)copyCache, (ForeignKeyDirection)foreignKeyDirection);
            persister.setPropertyValues(target, copiedValues2);
            return CompletionStages.voidFuture();
        }
        return EntityTypes.replace(persister.getPropertyValues(entity), persister.getPropertyValues(target), persister.getPropertyTypes(), source, target, (Map)copyCache, foreignKeyDirection).thenAccept(copiedValues -> persister.setPropertyValues(target, copiedValues));
    }

    protected CompletionStage<Void> cascadeOnMerge(EventSource source, EntityPersister persister, Object entity, MergeContext copyCache) {
        return new Cascade<MergeContext>(this.getCascadeReactiveAction(), CascadePoint.BEFORE_MERGE, persister, entity, copyCache, source).cascade();
    }

    @Override
    protected CascadingAction<MergeContext> getCascadeReactiveAction() {
        return CascadingActions.MERGE;
    }

    @Override
    protected CompletionStage<Void> cascadeAfterSave(EventSource source, EntityPersister persister, Object entity, MergeContext anything) {
        return CompletionStages.voidFuture();
    }

    @Override
    protected CompletionStage<Void> cascadeBeforeSave(EventSource source, EntityPersister persister, Object entity, MergeContext anything) {
        return CompletionStages.voidFuture();
    }
}

