/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.event.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.PersistentObjectException;
import org.hibernate.TypeMismatchException;
import org.hibernate.action.internal.DelayedPostInsertIdentifier;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.loader.entity.CacheEntityLoaderHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.reactive.event.ReactiveLoadEventListener;
import org.hibernate.reactive.event.impl.UnexpectedAccessToTheDatabase;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.session.impl.SessionUtil;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.tuple.IdentifierProperty;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class DefaultReactiveLoadEventListener
implements LoadEventListener,
ReactiveLoadEventListener {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public void onLoad(LoadEvent event, LoadEventListener.LoadType loadType) throws HibernateException {
        EntityPersister persister = this.getPersister(event);
        if (persister == null) {
            throw LOG.unableToLocatePersister(event.getEntityClassName());
        }
        CompletionStage<Void> checkId = this.checkId(event, loadType, persister);
        if (!checkId.toCompletableFuture().isDone()) {
            throw new UnexpectedAccessToTheDatabase();
        }
        try {
            CompletionStage<Object> loaded = this.doOnLoad(persister, event, loadType);
            if (!loaded.toCompletableFuture().isDone()) {
                throw new UnexpectedAccessToTheDatabase();
            }
            event.setResult(loaded.toCompletableFuture().getNow(null));
        }
        catch (HibernateException e) {
            LOG.unableToLoadCommand(e);
            throw e;
        }
        if (event.getResult() instanceof CompletionStage) {
            throw new AssertionFailure("Unexpected CompletionStage");
        }
    }

    @Override
    public CompletionStage<Void> reactiveOnLoad(LoadEvent event, LoadEventListener.LoadType loadType) throws HibernateException {
        ReactiveEntityPersister persister = (ReactiveEntityPersister)this.getPersister(event);
        if (persister == null) {
            throw LOG.unableToLocatePersister(event.getEntityClassName());
        }
        CompletionStage<Void> result = this.checkId(event, loadType, persister).thenCompose(vd -> this.doOnLoad(persister, event, loadType).thenAccept(arg_0 -> ((LoadEvent)event).setResult(arg_0)).handle((v, x) -> {
            if (event.getResult() instanceof CompletionStage) {
                throw new AssertionFailure("Unexpected CompletionStage");
            }
            if (x instanceof HibernateException) {
                LOG.unableToLoadCommand((HibernateException)((Object)((Object)x)));
            }
            return (Void)CompletionStages.returnNullorRethrow(x);
        }));
        if (event.getLockMode() == LockMode.PESSIMISTIC_FORCE_INCREMENT || event.getLockMode() == LockMode.FORCE) {
            return result.thenCompose(v -> persister.lockReactive(event.getEntityId(), persister.getVersion(event.getResult()), event.getResult(), event.getLockOptions(), (SharedSessionContractImplementor)event.getSession()));
        }
        return result;
    }

    private CompletionStage<Void> checkId(LoadEvent event, LoadEventListener.LoadType loadType, EntityPersister persister) {
        Class idClass = persister.getIdentifierType().getReturnedClass();
        if (idClass != null && !idClass.isInstance(event.getEntityId()) && !(event.getEntityId() instanceof DelayedPostInsertIdentifier)) {
            return this.checkIdClass(persister, event, loadType, idClass);
        }
        return CompletionStages.voidFuture();
    }

    protected EntityPersister getPersister(LoadEvent event) {
        Object instanceToLoad = event.getInstanceToLoad();
        if (instanceToLoad != null) {
            event.setEntityClassName(instanceToLoad.getClass().getName());
            return event.getSession().getEntityPersister(null, instanceToLoad);
        }
        return event.getSession().getFactory().getMetamodel().entityPersister(event.getEntityClassName());
    }

    private CompletionStage<Object> doOnLoad(EntityPersister persister, LoadEvent event, LoadEventListener.LoadType loadType) {
        EventSource session = event.getSession();
        EntityKey keyToLoad = session.generateEntityKey(event.getEntityId(), persister);
        if (loadType.isNakedEntityReturned()) {
            return this.load(event, persister, keyToLoad, loadType);
        }
        if (event.getLockMode() == LockMode.NONE) {
            return this.proxyOrLoad(event, persister, keyToLoad, loadType);
        }
        return this.lockAndLoad(event, persister, keyToLoad, loadType, (SessionImplementor)session);
    }

    private CompletionStage<Void> checkIdClass(EntityPersister persister, LoadEvent event, LoadEventListener.LoadType loadType, Class<?> idClass) {
        SessionFactoryImplementor factory;
        EntityType dependentParentType;
        Type dependentParentIdType;
        Type singleSubType;
        EmbeddedComponentType dependentIdType;
        IdentifierProperty identifierProperty = persister.getEntityMetamodel().getIdentifierProperty();
        if (identifierProperty.isEmbedded() && (dependentIdType = (EmbeddedComponentType)identifierProperty.getType()).getSubtypes().length == 1 && (singleSubType = dependentIdType.getSubtypes()[0]).isEntityType() && (dependentParentIdType = (dependentParentType = (EntityType)singleSubType).getIdentifierOrUniqueKeyType((Mapping)(factory = event.getSession().getFactory()))).getReturnedClass().isInstance(event.getEntityId())) {
            return this.loadByDerivedIdentitySimplePkValue(event, loadType, persister, dependentIdType, factory.getMetamodel().entityPersister(dependentParentType.getAssociatedEntityName()));
        }
        throw new TypeMismatchException("Provided id of the wrong type for class " + persister.getEntityName() + ". Expected: " + idClass + ", got " + event.getEntityId().getClass());
    }

    private CompletionStage<Void> loadByDerivedIdentitySimplePkValue(LoadEvent event, LoadEventListener.LoadType options, EntityPersister dependentPersister, EmbeddedComponentType dependentIdType, EntityPersister parentPersister) {
        EventSource session = event.getSession();
        EntityKey parentEntityKey = session.generateEntityKey(event.getEntityId(), parentPersister);
        return this.doLoad(event, parentPersister, parentEntityKey, options).thenApply(parent -> {
            SessionUtil.checkEntityFound((SharedSessionContractImplementor)session, parentEntityKey.getEntityName(), (Serializable)parentEntityKey, parent);
            Serializable dependent = (Serializable)dependentIdType.instantiate(parent, (SharedSessionContractImplementor)session);
            dependentIdType.setPropertyValues((Object)dependent, new Object[]{parent}, dependentPersister.getEntityMode());
            event.setEntityId(dependent);
            return session.generateEntityKey(dependent, dependentPersister);
        }).thenCompose(dependentEntityKey -> this.doLoad(event, dependentPersister, (EntityKey)dependentEntityKey, options)).thenAccept(arg_0 -> ((LoadEvent)event).setResult(arg_0));
    }

    private CompletionStage<Object> load(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        EventSource session = event.getSession();
        if (event.getInstanceToLoad() != null) {
            if (session.getPersistenceContextInternal().getEntry(event.getInstanceToLoad()) != null) {
                throw new PersistentObjectException("attempted to load into an instance that was already associated with the session: " + MessageHelper.infoString((EntityPersister)persister, (Object)event.getEntityId(), (SessionFactoryImplementor)session.getFactory()));
            }
            persister.setIdentifier(event.getInstanceToLoad(), event.getEntityId(), (SharedSessionContractImplementor)session);
        }
        return this.doLoad(event, persister, keyToLoad, options).thenApply(optional -> {
            boolean isOptionalInstance;
            boolean bl = isOptionalInstance = event.getInstanceToLoad() != null;
            if (optional == null && (!options.isAllowNulls() || isOptionalInstance)) {
                SessionUtil.throwEntityNotFound((SharedSessionContractImplementor)session, event.getEntityClassName(), event.getEntityId());
            } else if (isOptionalInstance && optional != event.getInstanceToLoad()) {
                throw new NonUniqueObjectException(event.getEntityId(), event.getEntityClassName());
            }
            return optional;
        });
    }

    private CompletionStage<Object> proxyOrLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        boolean entityHasHibernateProxyFactory;
        EventSource session = event.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled) {
            LOG.tracev("Loading entity: {0}", MessageHelper.infoString((EntityPersister)persister, (Object)event.getEntityId(), (SessionFactoryImplementor)factory));
        }
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        EntityMetamodel entityMetamodel = persister.getEntityMetamodel();
        boolean bl = entityHasHibernateProxyFactory = entityMetamodel.getTuplizer().getProxyFactory() != null;
        if (options.isAllowProxyCreation() && entityMetamodel.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading()) {
            Object managed = persistenceContext.getEntity(keyToLoad);
            if (managed != null) {
                EntityEntry entry;
                Status status;
                if (options.isCheckDeleted() && ((status = (entry = persistenceContext.getEntry(managed)).getStatus()) == Status.DELETED || status == Status.GONE)) {
                    return CompletionStages.nullFuture();
                }
                return CompletionStages.completedFuture(managed);
            }
            if (entityHasHibernateProxyFactory) {
                Object proxy = persistenceContext.getProxy(keyToLoad);
                if (proxy != null) {
                    if (traceEnabled) {
                        LOG.trace("Entity proxy found in session cache");
                    }
                    if (LOG.isDebugEnabled() && ((HibernateProxy)proxy).getHibernateLazyInitializer().isUnwrap()) {
                        LOG.debug("Ignoring NO_PROXY to honor laziness");
                    }
                    return CompletionStages.completedFuture(persistenceContext.narrowProxy(proxy, persister, keyToLoad, null));
                }
                if (entityMetamodel.hasSubclasses()) {
                    return CompletionStages.completedFuture(this.createProxy(event, persister, keyToLoad, persistenceContext));
                }
            }
            if (!entityMetamodel.hasSubclasses()) {
                if (keyToLoad.isBatchLoadable()) {
                    persistenceContext.getBatchFetchQueue().addBatchLoadableEntityKey(keyToLoad);
                }
                return CompletionStages.completedFuture(persister.getBytecodeEnhancementMetadata().createEnhancedProxy(keyToLoad, true, (SharedSessionContractImplementor)session));
            }
        } else if (persister.hasProxy()) {
            Object proxy = persistenceContext.getProxy(keyToLoad);
            if (proxy != null) {
                return this.returnNarrowedProxy(event, persister, keyToLoad, options, persistenceContext, proxy);
            }
            if (options.isAllowProxyCreation()) {
                return CompletionStages.completedFuture(this.createProxyIfNecessary(event, persister, keyToLoad, options, persistenceContext));
            }
        }
        return this.load(event, persister, keyToLoad, options);
    }

    private CompletionStage<Object> returnNarrowedProxy(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, PersistenceContext persistenceContext, Object proxy) {
        LazyInitializer li;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Entity proxy found in session cache");
        }
        if ((li = ((HibernateProxy)proxy).getHibernateLazyInitializer()).isUnwrap()) {
            return CompletionStages.completedFuture(li.getImplementation());
        }
        CompletionStage<Object> implStage = !options.isAllowProxyCreation() ? this.load(event, persister, keyToLoad, options).thenApply(optional -> {
            if (optional == null) {
                event.getSession().getFactory().getEntityNotFoundDelegate().handleEntityNotFound(persister.getEntityName(), keyToLoad.getIdentifier());
            }
            return optional;
        }) : CompletionStages.nullFuture();
        return implStage.thenApply(impl -> persistenceContext.narrowProxy(proxy, persister, keyToLoad, impl));
    }

    private Object createProxyIfNecessary(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, PersistenceContext persistenceContext) {
        Object existing = persistenceContext.getEntity(keyToLoad);
        boolean traceEnabled = LOG.isTraceEnabled();
        if (existing != null) {
            EntityEntry entry;
            Status status;
            if (traceEnabled) {
                LOG.trace("Entity found in session cache");
            }
            if (options.isCheckDeleted() && ((status = (entry = persistenceContext.getEntry(existing)).getStatus()) == Status.DELETED || status == Status.GONE)) {
                return null;
            }
            return existing;
        }
        if (traceEnabled) {
            LOG.trace("Creating new proxy for entity");
        }
        return this.createProxy(event, persister, keyToLoad, persistenceContext);
    }

    private Object createProxy(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, PersistenceContext persistenceContext) {
        Object proxy = persister.createProxy(event.getEntityId(), (SharedSessionContractImplementor)event.getSession());
        persistenceContext.getBatchFetchQueue().addBatchLoadableEntityKey(keyToLoad);
        persistenceContext.addProxy(keyToLoad, proxy);
        return proxy;
    }

    private CompletionStage<Object> lockAndLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, SessionImplementor source) {
        SoftLock lock;
        Object cacheKey;
        boolean canWriteToCache = persister.canWriteToCache();
        if (canWriteToCache) {
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            cacheKey = cache.generateCacheKey((Object)event.getEntityId(), persister, source.getFactory(), source.getTenantIdentifier());
            lock = cache.lockItem((SharedSessionContractImplementor)source, cacheKey, null);
        } else {
            cacheKey = null;
            lock = null;
        }
        try {
            return this.load(event, persister, keyToLoad, options).whenComplete((v, x) -> {
                if (canWriteToCache) {
                    persister.getCacheAccessStrategy().unlockItem((SharedSessionContractImplementor)source, cacheKey, lock);
                }
            }).thenApply(entity -> source.getPersistenceContextInternal().proxyFor(persister, keyToLoad, entity));
        }
        catch (HibernateException he) {
            if (canWriteToCache) {
                persister.getCacheAccessStrategy().unlockItem((SharedSessionContractImplementor)source, cacheKey, lock);
            }
            throw he;
        }
    }

    private CompletionStage<Object> doLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        CacheEntityLoaderHelper.PersistenceContextEntry persistenceContextEntry;
        Object entity;
        EventSource session = event.getSession();
        boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled) {
            LOG.tracev("Attempting to resolve: {0}", MessageHelper.infoString((EntityPersister)persister, (Object)event.getEntityId(), (SessionFactoryImplementor)session.getFactory()));
        }
        if ((entity = (persistenceContextEntry = CacheEntityLoaderHelper.INSTANCE.loadFromSessionCache(event, keyToLoad, options)).getEntity()) != null) {
            Object managed = persistenceContextEntry.isManaged() ? entity : null;
            return CompletionStages.completedFuture(managed);
        }
        entity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(event, persister, keyToLoad);
        if (entity != null) {
            if (traceEnabled) {
                LOG.tracev("Resolved object in second-level cache: {0}", MessageHelper.infoString((EntityPersister)persister, (Object)event.getEntityId(), (SessionFactoryImplementor)session.getFactory()));
            }
            this.cacheNaturalId(event, persister, session, entity);
            return CompletionStages.completedFuture(entity);
        }
        if (traceEnabled) {
            LOG.tracev("Object not resolved in any cache: {0}", MessageHelper.infoString((EntityPersister)persister, (Object)event.getEntityId(), (SessionFactoryImplementor)session.getFactory()));
        }
        return this.loadFromDatasource(event, persister).thenApply(optional -> {
            if (optional != null) {
                this.cacheNaturalId(event, persister, session, optional);
            }
            return optional;
        });
    }

    private void cacheNaturalId(LoadEvent event, EntityPersister persister, EventSource session, Object entity) {
        if (entity != null && persister.hasNaturalIdentifier()) {
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            PersistenceContext.NaturalIdHelper naturalIdHelper = persistenceContext.getNaturalIdHelper();
            naturalIdHelper.cacheNaturalIdCrossReferenceFromLoad(persister, event.getEntityId(), naturalIdHelper.extractNaturalIdValues(entity, persister));
        }
    }

    protected CompletionStage<Object> loadFromDatasource(LoadEvent event, EntityPersister persister) {
        CompletionStage<Object> entity = ((ReactiveEntityPersister)persister).reactiveLoad(event.getEntityId(), event.getInstanceToLoad(), event.getLockOptions(), (SharedSessionContractImplementor)event.getSession());
        StatisticsImplementor statistics = event.getSession().getFactory().getStatistics();
        if (event.isAssociationFetch() && statistics.isStatisticsEnabled()) {
            statistics.fetchEntity(event.getEntityClassName());
        }
        return entity;
    }
}

