/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.event.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.TransientObjectException;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.Nullability;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.OnUpdateVisitor;
import org.hibernate.event.service.spi.JpaBootstrapSensitive;
import org.hibernate.event.spi.DeleteEvent;
import org.hibernate.event.spi.DeleteEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.jpa.event.spi.CallbackRegistry;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.engine.ReactiveActionQueue;
import org.hibernate.reactive.engine.impl.Cascade;
import org.hibernate.reactive.engine.impl.CascadingActions;
import org.hibernate.reactive.engine.impl.ForeignKeys;
import org.hibernate.reactive.engine.impl.ReactiveEntityDeleteAction;
import org.hibernate.reactive.engine.impl.ReactiveOrphanRemovalAction;
import org.hibernate.reactive.event.ReactiveDeleteEventListener;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;

public class DefaultReactiveDeleteEventListener
implements DeleteEventListener,
ReactiveDeleteEventListener,
CallbackRegistryConsumer,
JpaBootstrapSensitive {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private CallbackRegistry callbackRegistry;
    private boolean jpaBootstrap;

    public void injectCallbackRegistry(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    public void wasJpaBootstrap(boolean wasJpaBootstrap) {
        this.jpaBootstrap = wasJpaBootstrap;
    }

    public void onDelete(DeleteEvent event) {
        throw new UnsupportedOperationException();
    }

    public void onDelete(DeleteEvent event, Set transientEntities) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<Void> reactiveOnDelete(DeleteEvent event) throws HibernateException {
        return this.reactiveOnDelete(event, new IdentitySet());
    }

    @Override
    public CompletionStage<Void> reactiveOnDelete(DeleteEvent event, IdentitySet transientEntities) throws HibernateException {
        boolean detached;
        EventSource source = event.getSession();
        boolean bl = event.getEntityName() != null ? !source.contains(event.getEntityName(), event.getObject()) : (detached = !source.contains(event.getObject()));
        if (detached) {
            throw new IllegalArgumentException("unmanaged instance passed to remove()");
        }
        return ((ReactiveSession)source).reactiveFetch(event.getObject(), true).thenCompose(entity -> this.reactiveOnDelete(event, transientEntities, entity));
    }

    private CompletionStage<Void> reactiveOnDelete(DeleteEvent event, IdentitySet transientEntities, Object entity) {
        EventSource source = event.getSession();
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        EntityEntry entityEntry = persistenceContext.getEntry(entity);
        if (entityEntry == null) {
            LOG.trace("Entity was not persistent in delete processing");
            EntityPersister persister = source.getEntityPersister(event.getEntityName(), entity);
            return ForeignKeys.isTransient(persister.getEntityName(), entity, null, source.getSession()).thenCompose(trans -> {
                if (trans.booleanValue()) {
                    return this.deleteTransientEntity(source, entity, event.isCascadeDeleteEnabled(), persister, transientEntities);
                }
                this.performDetachedEntityDeletionCheck(event);
                Serializable id = persister.getIdentifier(entity, (SharedSessionContractImplementor)source);
                if (id == null) {
                    throw new TransientObjectException("the detached instance passed to delete() had a null identifier");
                }
                EntityKey key = source.generateEntityKey(id, persister);
                persistenceContext.checkUniqueness(key, entity);
                new OnUpdateVisitor(source, id, entity).process(entity, persister);
                Object version = persister.getVersion(entity);
                EntityEntry entry = persistenceContext.addEntity(entity, persister.isMutable() ? Status.MANAGED : Status.READ_ONLY, persister.getPropertyValues(entity), key, version, LockMode.NONE, true, persister, false);
                persister.afterReassociate(entity, (SharedSessionContractImplementor)source);
                this.callbackRegistry.preRemove(entity);
                return this.deleteEntity(source, entity, entry, event.isCascadeDeleteEnabled(), event.isOrphanRemovalBeforeUpdates(), persister, transientEntities).thenAccept(v -> {
                    if (source.getFactory().getSessionFactoryOptions().isIdentifierRollbackEnabled()) {
                        persister.resetIdentifier(entity, id, version, (SharedSessionContractImplementor)source);
                    }
                });
            });
        }
        LOG.trace("Deleting a persistent instance");
        Status status = entityEntry.getStatus();
        if (status == Status.DELETED || status == Status.GONE) {
            LOG.trace("Object was already deleted");
            return CompletionStages.voidFuture();
        }
        EntityPersister persister = entityEntry.getPersister();
        Serializable id = entityEntry.getId();
        Object version = entityEntry.getVersion();
        this.callbackRegistry.preRemove(entity);
        return this.deleteEntity(source, entity, entityEntry, event.isCascadeDeleteEnabled(), event.isOrphanRemovalBeforeUpdates(), persister, transientEntities).thenAccept(v -> {
            if (source.getFactory().getSessionFactoryOptions().isIdentifierRollbackEnabled()) {
                persister.resetIdentifier(entity, id, version, (SharedSessionContractImplementor)source);
            }
        });
    }

    protected void performDetachedEntityDeletionCheck(DeleteEvent event) {
        if (this.jpaBootstrap) {
            this.disallowDeletionOfDetached(event);
        }
    }

    private void disallowDeletionOfDetached(DeleteEvent event) {
        EventSource source = event.getSession();
        String entityName = event.getEntityName();
        EntityPersister persister = source.getEntityPersister(entityName, event.getObject());
        Serializable id = persister.getIdentifier(event.getObject(), (SharedSessionContractImplementor)source);
        entityName = entityName == null ? source.guessEntityName(event.getObject()) : entityName;
        throw new IllegalArgumentException("Removing a detached instance " + entityName + "#" + id);
    }

    protected CompletionStage<Void> deleteTransientEntity(EventSource session, Object entity, boolean cascadeDeleteEnabled, EntityPersister persister, IdentitySet transientEntities) {
        LOG.handlingTransientEntity();
        if (transientEntities.contains(entity)) {
            LOG.trace("Already handled transient entity; skipping");
            return CompletionStages.voidFuture();
        }
        transientEntities.add(entity);
        return this.cascadeBeforeDelete(session, persister, entity, null, transientEntities).thenCompose(v -> this.cascadeAfterDelete(session, persister, entity, transientEntities));
    }

    protected CompletionStage<Void> deleteEntity(EventSource session, Object entity, EntityEntry entityEntry, boolean isCascadeDeleteEnabled, boolean isOrphanRemovalBeforeUpdates, EntityPersister persister, IdentitySet transientEntities) {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Deleting {0}", MessageHelper.infoString((EntityPersister)persister, (Object)entityEntry.getId(), (SessionFactoryImplementor)session.getFactory()));
        }
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        Type[] propTypes = persister.getPropertyTypes();
        Object version = entityEntry.getVersion();
        Object[] currentState = entityEntry.getLoadedState() == null ? persister.getPropertyValues(entity) : entityEntry.getLoadedState();
        Object[] deletedState = this.createDeletedState(persister, currentState, session);
        entityEntry.setDeletedState(deletedState);
        session.getInterceptor().onDelete(entity, entityEntry.getId(), deletedState, persister.getPropertyNames(), propTypes);
        persistenceContext.setEntryStatus(entityEntry, Status.DELETED);
        EntityKey key = session.generateEntityKey(entityEntry.getId(), persister);
        CompletionStage<Void> beforeDelete = this.cascadeBeforeDelete(session, persister, entity, entityEntry, transientEntities);
        CompletionStage<Void> nullifyAndAction = new ForeignKeys.Nullifier(entity, true, false, (SessionImplementor)session, persister).nullifyTransientReferences(entityEntry.getDeletedState()).thenAccept(v -> {
            new Nullability((SharedSessionContractImplementor)session).checkNullability(entityEntry.getDeletedState(), persister, Nullability.NullabilityCheckType.DELETE);
            persistenceContext.registerNullifiableEntityKey(key);
            ReactiveActionQueue actionQueue = this.actionQueue(session);
            if (isOrphanRemovalBeforeUpdates) {
                actionQueue.addAction(new ReactiveOrphanRemovalAction(entityEntry.getId(), deletedState, version, entity, persister, isCascadeDeleteEnabled, (SessionImplementor)session));
            } else {
                actionQueue.addAction(new ReactiveEntityDeleteAction(entityEntry.getId(), deletedState, version, entity, persister, isCascadeDeleteEnabled, (SessionImplementor)session));
            }
        });
        CompletionStage<Void> afterDelete = this.cascadeAfterDelete(session, persister, entity, transientEntities);
        return beforeDelete.thenCompose(v -> nullifyAndAction).thenCompose(v -> afterDelete);
    }

    private ReactiveActionQueue actionQueue(EventSource session) {
        return ((ReactiveSession)session.unwrap(ReactiveSession.class)).getReactiveActionQueue();
    }

    private Object[] createDeletedState(EntityPersister persister, Object[] currentState, EventSource session) {
        Type[] propTypes = persister.getPropertyTypes();
        Object[] deletedState = new Object[propTypes.length];
        boolean[] copyability = new boolean[propTypes.length];
        Arrays.fill(copyability, true);
        TypeHelper.deepCopy((Object[])currentState, (Type[])propTypes, (boolean[])copyability, (Object[])deletedState, (SharedSessionContractImplementor)session);
        return deletedState;
    }

    protected CompletionStage<Void> cascadeBeforeDelete(EventSource session, EntityPersister persister, Object entity, EntityEntry entityEntry, IdentitySet transientEntities) throws HibernateException {
        return Cascade.fetchLazyAssociationsBeforeCascade(CascadingActions.DELETE, persister, entity, session).thenCompose(v -> new Cascade<IdentitySet>(CascadingActions.DELETE, CascadePoint.AFTER_INSERT_BEFORE_DELETE, persister, entity, transientEntities, session).cascade());
    }

    protected CompletionStage<Void> cascadeAfterDelete(EventSource session, EntityPersister persister, Object entity, IdentitySet transientEntities) throws HibernateException {
        return new Cascade<IdentitySet>(CascadingActions.DELETE, CascadePoint.BEFORE_INSERT_AFTER_DELETE, persister, entity, transientEntities, session).cascade();
    }
}

