/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.event.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.reactive.engine.ReactiveActionQueue;
import org.hibernate.reactive.event.ReactiveAutoFlushEventListener;
import org.hibernate.reactive.event.impl.AbstractReactiveFlushingEventListener;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.spi.StatisticsImplementor;

public class DefaultReactiveAutoFlushEventListener
extends AbstractReactiveFlushingEventListener
implements ReactiveAutoFlushEventListener,
AutoFlushEventListener {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    @Override
    public CompletionStage<Void> reactiveOnAutoFlush(AutoFlushEvent event) throws HibernateException {
        EventSource source = event.getSession();
        SessionEventListenerManager eventListenerManager = source.getEventListenerManager();
        eventListenerManager.partialFlushStart();
        CompletionStage<Void> autoFlushStage = CompletionStages.voidFuture();
        if (this.flushMightBeNeeded(source)) {
            ReactiveActionQueue actionQueue = this.reactiveActionQueue(event);
            int oldSize = actionQueue.numberOfCollectionRemovals();
            autoFlushStage = this.flushEverythingToExecutions((FlushEvent)event).thenCompose(v -> {
                if (this.flushIsReallyNeeded(event, source)) {
                    LOG.trace("Need to execute flush");
                    event.setFlushRequired(true);
                    return this.performExecutions(source).thenRun(() -> this.postFlush((SessionImplementor)source)).thenRun(() -> this.postPostFlush((SessionImplementor)source)).thenRun(() -> {
                        StatisticsImplementor statistics = source.getFactory().getStatistics();
                        if (statistics.isStatisticsEnabled()) {
                            statistics.flush();
                        }
                    });
                }
                LOG.trace("Don't need to execute flush");
                event.setFlushRequired(false);
                actionQueue.clearFromFlushNeededCheck(oldSize);
                return CompletionStages.voidFuture();
            });
        }
        return autoFlushStage.whenComplete((v, x) -> source.getEventListenerManager().partialFlushEnd(event.getNumberOfEntitiesProcessed(), event.getNumberOfCollectionsProcessed()));
    }

    private ReactiveActionQueue reactiveActionQueue(AutoFlushEvent event) {
        return ((ReactiveSession)event.getSession().unwrap(ReactiveSession.class)).getReactiveActionQueue();
    }

    private boolean flushIsReallyNeeded(AutoFlushEvent event, EventSource source) {
        return source.getHibernateFlushMode() == FlushMode.ALWAYS || this.reactiveActionQueue(source).areTablesToBeUpdated(event.getQuerySpaces());
    }

    private ReactiveActionQueue reactiveActionQueue(EventSource source) {
        return ((ReactiveSession)source.unwrap(ReactiveSession.class)).getReactiveActionQueue();
    }

    private boolean flushMightBeNeeded(EventSource source) {
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        return !source.getHibernateFlushMode().lessThan(FlushMode.AUTO) && source.getDontFlushFromFind() == 0 && (persistenceContext.getNumberOfManagedEntities() > 0 || persistenceContext.getCollectionEntriesSize() > 0);
    }

    public void onAutoFlush(AutoFlushEvent event) throws HibernateException {
        throw new UnsupportedOperationException("use reactiveOnAutoFlush instead");
    }
}

