/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.event.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityEntryExtraState;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.WrapVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.jpa.event.spi.CallbackRegistry;
import org.hibernate.jpa.event.spi.CallbackRegistryConsumer;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.engine.impl.Cascade;
import org.hibernate.reactive.engine.impl.CascadingAction;
import org.hibernate.reactive.engine.impl.ReactiveEntityIdentityInsertAction;
import org.hibernate.reactive.engine.impl.ReactiveEntityRegularInsertAction;
import org.hibernate.reactive.id.impl.IdentifierGeneration;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.hibernate.type.VersionType;

abstract class AbstractReactiveSaveEventListener<C>
implements CallbackRegistryConsumer {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private CallbackRegistry callbackRegistry;

    AbstractReactiveSaveEventListener() {
    }

    public void injectCallbackRegistry(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    protected CompletionStage<Void> reactiveSaveWithRequestedId(Object entity, Serializable requestedId, String entityName, C context, EventSource source) {
        this.callbackRegistry.preCreate(entity);
        return this.reactivePerformSave(entity, requestedId, source.getEntityPersister(entityName, entity), false, context, source, true);
    }

    protected CompletionStage<Void> reactiveSaveWithGeneratedId(Object entity, String entityName, C context, EventSource source, boolean requiresImmediateIdAccess) {
        this.callbackRegistry.preCreate(entity);
        if (entity instanceof SelfDirtinessTracker) {
            ((SelfDirtinessTracker)entity).$$_hibernate_clearDirtyAttributes();
        }
        EntityPersister persister = source.getEntityPersister(entityName, entity);
        boolean autoincrement = persister.isIdentifierAssignedByInsert();
        return IdentifierGeneration.generateId(entity, persister, (ReactiveSession)source, (SharedSessionContractImplementor)source.getSession()).thenCompose(id -> this.reactivePerformSave(entity, autoincrement ? null : IdentifierGeneration.assignIdIfNecessary(id, entity, persister, (SharedSessionContractImplementor)source.getSession()), persister, autoincrement, context, source, !autoincrement || requiresImmediateIdAccess));
    }

    protected CompletionStage<Void> reactivePerformSave(Object entity, Serializable id, EntityPersister persister, boolean useIdentityColumn, C context, EventSource source, boolean requiresImmediateIdAccess) {
        EntityKey key;
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Saving {0}", MessageHelper.infoString((EntityPersister)persister, (Object)id, (SessionFactoryImplementor)source.getFactory()));
        }
        if (!useIdentityColumn) {
            key = source.generateEntityKey(id, persister);
            PersistenceContext persistenceContext = source.getPersistenceContextInternal();
            Object old = persistenceContext.getEntity(key);
            if (old != null) {
                if (persistenceContext.getEntry(old).getStatus() == Status.DELETED) {
                    source.forceFlush(persistenceContext.getEntry(old));
                } else {
                    return CompletionStages.failedFuture((Throwable)new NonUniqueObjectException(id, persister.getEntityName()));
                }
            }
            persister.setIdentifier(entity, id, (SharedSessionContractImplementor)source);
        } else {
            key = null;
        }
        return this.reactivePerformSaveOrReplicate(entity, key, persister, useIdentityColumn, context, source, requiresImmediateIdAccess);
    }

    protected CompletionStage<Void> reactivePerformSaveOrReplicate(Object entity, EntityKey key, EntityPersister persister, boolean useIdentityColumn, C context, EventSource source, boolean requiresImmediateIdAccess) {
        Serializable id = key == null ? null : key.getIdentifier();
        boolean inTransaction = source.isTransactionInProgress();
        boolean shouldDelayIdentityInserts = !inTransaction && !requiresImmediateIdAccess;
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        EntityEntry original = persistenceContext.addEntry(entity, Status.SAVING, null, null, id, null, LockMode.WRITE, useIdentityColumn, persister, false);
        return this.cascadeBeforeSave(source, persister, entity, context).thenCompose(v -> {
            EntityEntryExtraState extraState;
            Object[] values = persister.getPropertyValuesToInsert(entity, this.getMergeMap(context), (SharedSessionContractImplementor)source);
            Type[] types = persister.getPropertyTypes();
            boolean substitute = this.substituteValuesIfNecessary(entity, id, values, persister, (SessionImplementor)source);
            if (persister.hasCollections()) {
                boolean substituteBecauseOfCollections = this.visitCollectionsBeforeSave(entity, id, values, types, source);
                boolean bl = substitute = substitute || substituteBecauseOfCollections;
            }
            if (substitute) {
                persister.setPropertyValues(entity, values);
            }
            TypeHelper.deepCopy((Object[])values, (Type[])types, (boolean[])persister.getPropertyUpdateability(), (Object[])values, (SharedSessionContractImplementor)source);
            CompletionStage<AbstractEntityInsertAction> insert = this.addInsertAction(values, id, entity, persister, useIdentityColumn, source, shouldDelayIdentityInserts);
            EntityEntry newEntry = persistenceContext.getEntry(entity);
            if (newEntry != original && (extraState = newEntry.getExtraState(EntityEntryExtraState.class)) == null) {
                newEntry.addExtraState(original.getExtraState(EntityEntryExtraState.class));
            }
            return insert;
        }).thenCompose(vv -> this.cascadeAfterSave(source, persister, entity, context));
    }

    protected Map<?, ?> getMergeMap(Object context) {
        return null;
    }

    private CompletionStage<AbstractEntityInsertAction> addInsertAction(Object[] values, Serializable id, Object entity, EntityPersister persister, boolean useIdentityColumn, EventSource source, boolean shouldDelayIdentityInserts) {
        if (useIdentityColumn) {
            ReactiveEntityIdentityInsertAction insert = new ReactiveEntityIdentityInsertAction(values, entity, persister, false, (SharedSessionContractImplementor)source, shouldDelayIdentityInserts);
            return ((ReactiveSession)source.unwrap(ReactiveSession.class)).getReactiveActionQueue().addAction(insert).thenApply(v -> insert);
        }
        Object version = Versioning.getVersion((Object[])values, (EntityPersister)persister);
        ReactiveEntityRegularInsertAction insert = new ReactiveEntityRegularInsertAction(id, values, entity, version, persister, false, (SharedSessionContractImplementor)source);
        return ((ReactiveSession)source.unwrap(ReactiveSession.class)).getReactiveActionQueue().addAction(insert).thenApply(v -> insert);
    }

    protected CompletionStage<Void> cascadeBeforeSave(EventSource source, EntityPersister persister, Object entity, C context) {
        return new Cascade<C>(this.getCascadeReactiveAction(), CascadePoint.BEFORE_INSERT_AFTER_DELETE, persister, entity, context, source).cascade();
    }

    protected CompletionStage<Void> cascadeAfterSave(EventSource source, EntityPersister persister, Object entity, C context) {
        return new Cascade<C>(this.getCascadeReactiveAction(), CascadePoint.AFTER_INSERT_BEFORE_DELETE, persister, entity, context, source).cascade();
    }

    protected abstract CascadingAction<C> getCascadeReactiveAction();

    protected boolean substituteValuesIfNecessary(Object entity, Serializable id, Object[] values, EntityPersister persister, SessionImplementor source) {
        boolean substitute = source.getInterceptor().onSave(entity, id, values, persister.getPropertyNames(), persister.getPropertyTypes());
        if (persister.isVersioned()) {
            substitute = Versioning.seedVersion((Object[])values, (int)persister.getVersionProperty(), (VersionType)persister.getVersionType(), (SharedSessionContractImplementor)source) || substitute;
        }
        return substitute;
    }

    protected boolean visitCollectionsBeforeSave(Object entity, Serializable id, Object[] values, Type[] types, EventSource source) {
        WrapVisitor visitor = new WrapVisitor(entity, id, source);
        visitor.processEntityPropertyValues(values, types);
        return visitor.isSubstitutionRequired();
    }
}

