/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import org.hibernate.dialect.lock.OptimisticEntityLockException;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.engine.ReactiveBeforeTransactionCompletionProcess;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;

public class ReactiveEntityVerifyVersionProcess
implements ReactiveBeforeTransactionCompletionProcess {
    private final Object object;

    public ReactiveEntityVerifyVersionProcess(Object object) {
        this.object = object;
    }

    @Override
    public CompletionStage<Void> doBeforeTransactionCompletion(ReactiveSession session) {
        EntityEntry entry = session.getPersistenceContext().getEntry(this.object);
        if (entry == null) {
            return CompletionStages.voidFuture();
        }
        return ((ReactiveEntityPersister)entry.getPersister()).reactiveGetCurrentVersion(entry.getId(), (SharedSessionContractImplementor)session.getSharedContract()).thenAccept(latestVersion -> {
            if (!entry.getVersion().equals(latestVersion)) {
                throw new OptimisticEntityLockException(this.object, "Newer version [" + latestVersion + "] of entity [" + MessageHelper.infoString((String)entry.getEntityName(), (Serializable)entry.getId()) + "] found in database");
            }
        });
    }
}

