/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.EntityUpdateAction;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.engine.ReactiveExecutable;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.internal.StatsHelper;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;

public class ReactiveEntityUpdateAction
extends EntityUpdateAction
implements ReactiveExecutable {
    public ReactiveEntityUpdateAction(Serializable id, Object[] state, int[] dirtyProperties, boolean hasDirtyCollection, Object[] previousState, Object previousVersion, Object nextVersion, Object instance, Object rowId, EntityPersister persister, SharedSessionContractImplementor session) {
        super(id, state, dirtyProperties, hasDirtyCollection, previousState, previousVersion, nextVersion, instance, rowId, persister, session);
    }

    @Override
    public CompletionStage<Void> reactiveExecute() throws HibernateException {
        Object ck;
        Serializable id = this.getId();
        EntityPersister persister = this.getPersister();
        SharedSessionContractImplementor session = this.getSession();
        Object instance = this.getInstance();
        boolean veto = this.preUpdate();
        SessionFactoryImplementor factory = session.getFactory();
        Object previousVersion = this.getPreviousVersion();
        if (persister.isVersionPropertyGenerated()) {
            previousVersion = persister.getVersion(instance);
        }
        if (persister.canWriteToCache()) {
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            ck = cache.generateCacheKey((Object)id, persister, factory, session.getTenantIdentifier());
            this.setLock(cache.lockItem(session, ck, previousVersion));
        } else {
            ck = null;
        }
        ReactiveEntityPersister reactivePersister = (ReactiveEntityPersister)persister;
        CompletionStage<Void> update = veto ? CompletionStages.voidFuture() : reactivePersister.updateReactive(id, this.getState(), this.getDirtyFields(), this.hasDirtyCollection(), this.getPreviousState(), previousVersion, instance, this.getRowId(), session);
        return update.thenApply(res -> {
            EntityEntry entry = session.getPersistenceContextInternal().getEntry(instance);
            if (entry == null) {
                throw new AssertionFailure("possible non-threadsafe access to session");
            }
            return entry;
        }).thenCompose(entry -> {
            if (entry.getStatus() == Status.MANAGED || persister.isVersionPropertyGenerated()) {
                TypeHelper.deepCopy((Object[])this.getState(), (Type[])persister.getPropertyTypes(), (boolean[])persister.getPropertyCheckability(), (Object[])this.getState(), (SharedSessionContractImplementor)session);
                return this.processGeneratedProperties(id, reactivePersister, session, instance).thenAccept(v -> entry.postUpdate(instance, this.getState(), this.getNextVersion())).thenApply(v -> entry);
            }
            return CompletionStages.completedFuture(entry);
        }).thenAccept(entry -> {
            StatisticsImplementor statistics = factory.getStatistics();
            if (persister.canWriteToCache()) {
                if (persister.isCacheInvalidationRequired() || entry.getStatus() != Status.MANAGED) {
                    persister.getCacheAccessStrategy().remove(session, ck);
                } else if (session.getCacheMode().isPutEnabled()) {
                    CacheEntry ce = persister.buildCacheEntry(instance, this.getState(), this.getNextVersion(), this.getSession());
                    this.setCacheEntry(persister.getCacheEntryStructure().structure((Object)ce));
                    boolean put = this.cacheUpdate(persister, this.getPreviousVersion(), ck);
                    if (put && statistics.isStatisticsEnabled()) {
                        statistics.entityCachePut(StatsHelper.INSTANCE.getRootEntityRole(persister), this.getPersister().getCacheAccessStrategy().getRegion().getName());
                    }
                }
            }
            session.getPersistenceContextInternal().getNaturalIdHelper().manageSharedNaturalIdCrossReference(persister, id, this.getState(), this.getPreviousNaturalIdValues(), CachedNaturalIdValueSource.UPDATE);
            this.postUpdate();
            if (statistics.isStatisticsEnabled() && !veto) {
                statistics.updateEntity(this.getPersister().getEntityName());
            }
        });
    }

    private CompletionStage<Void> processGeneratedProperties(Serializable id, ReactiveEntityPersister persister, SharedSessionContractImplementor session, Object instance) {
        if (persister.hasUpdateGeneratedProperties()) {
            if (persister.isVersionPropertyGenerated()) {
                throw new UnsupportedOperationException("generated version attribute not supported in Hibernate Reactive");
            }
            return persister.reactiveProcessUpdateGenerated(id, instance, this.getState(), session);
        }
        return CompletionStages.voidFuture();
    }

    public void execute() throws HibernateException {
        throw new UnsupportedOperationException("This action only support reactive functions calls");
    }
}

