/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.EntityInsertAction;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.engine.impl.ReactiveEntityInsertAction;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.util.impl.CompletionStages;

public class ReactiveEntityRegularInsertAction
extends EntityInsertAction
implements ReactiveEntityInsertAction {
    private final boolean isVersionIncrementDisabled;
    private boolean executed;
    private boolean transientReferencesNullified;

    public ReactiveEntityRegularInsertAction(Serializable id, Object[] state, Object instance, Object version, EntityPersister persister, boolean isVersionIncrementDisabled, SharedSessionContractImplementor session) {
        super(id, state, instance, version, persister, isVersionIncrementDisabled, session);
        this.isVersionIncrementDisabled = isVersionIncrementDisabled;
    }

    public void execute() throws HibernateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<Void> reactiveExecute() throws HibernateException {
        return this.reactiveNullifyTransientReferencesIfNotAlready().thenCompose(v -> {
            CompletionStage<Void> insertStage;
            EntityPersister persister = this.getPersister();
            SharedSessionContractImplementor session = this.getSession();
            Object instance = this.getInstance();
            Serializable id = this.getId();
            boolean veto = this.preInsert();
            if (!veto) {
                ReactiveEntityPersister reactivePersister = (ReactiveEntityPersister)persister;
                insertStage = reactivePersister.insertReactive(id, this.getState(), instance, session).thenApply(res -> {
                    EntityEntry entry = session.getPersistenceContext().getEntry(instance);
                    if (entry == null) {
                        throw new AssertionFailure("possible non-threadsafe access to session");
                    }
                    entry.postInsert(this.getState());
                    return entry;
                }).thenCompose(entry -> this.processInsertGeneratedProperties(reactivePersister, session, instance, id, (EntityEntry)entry).thenAccept(vv -> session.getPersistenceContext().registerInsertedKey(persister, this.getId())));
            } else {
                insertStage = CompletionStages.voidFuture();
            }
            return insertStage.thenApply(res -> {
                SessionFactoryImplementor factory = session.getFactory();
                if (this.isCachePutEnabled(persister, session)) {
                    CacheEntry ce = persister.buildCacheEntry(instance, this.getState(), this.getVersion(), session);
                    this.setCacheEntry(persister.getCacheEntryStructure().structure((Object)ce));
                    EntityDataAccess cache = persister.getCacheAccessStrategy();
                    Object ck = cache.generateCacheKey((Object)id, persister, factory, session.getTenantIdentifier());
                    boolean put = this.cacheInsert(persister, ck);
                    if (put && factory.getStatistics().isStatisticsEnabled()) {
                        factory.getStatistics().entityCachePut(persister.getNavigableRole(), persister.getCacheAccessStrategy().getRegion().getName());
                    }
                }
                this.handleNaturalIdPostSaveNotifications(id);
                this.postInsert();
                if (factory.getStatistics().isStatisticsEnabled() && !veto) {
                    factory.getStatistics().insertEntity(this.getEntityName());
                }
                this.markExecuted();
                return null;
            });
        });
    }

    private CompletionStage<Void> processInsertGeneratedProperties(ReactiveEntityPersister persister, SharedSessionContractImplementor session, Object instance, Serializable id, EntityEntry entry) {
        if (persister.hasInsertGeneratedProperties()) {
            if (persister.isVersionPropertyGenerated()) {
                throw new UnsupportedOperationException("generated version attribute not supported in Hibernate Reactive");
            }
            return persister.reactiveProcessInsertGenerated(id, instance, this.getState(), session).thenAccept(v -> entry.postUpdate(instance, this.getState(), this.getVersion()));
        }
        return CompletionStages.voidFuture();
    }

    @Override
    public EntityKey getEntityKey() {
        return super.getEntityKey();
    }

    protected void markExecuted() {
        super.markExecuted();
        this.executed = true;
    }

    @Override
    public boolean isExecuted() {
        return this.executed;
    }

    @Override
    public boolean isVersionIncrementDisabled() {
        return this.isVersionIncrementDisabled;
    }

    @Override
    public boolean areTransientReferencesNullified() {
        return this.transientReferencesNullified;
    }

    @Override
    public void setTransientReferencesNullified() {
        this.transientReferencesNullified = true;
    }
}

