/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.util.concurrent.CompletionStage;
import org.hibernate.LockMode;
import org.hibernate.engine.internal.NonNullableTransientDependencies;
import org.hibernate.engine.internal.Nullability;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.engine.ReactiveExecutable;
import org.hibernate.reactive.engine.impl.ForeignKeys;
import org.hibernate.reactive.util.impl.CompletionStages;

public interface ReactiveEntityInsertAction
extends ReactiveExecutable {
    public boolean isEarlyInsert();

    public NonNullableTransientDependencies findNonNullableTransientEntities();

    public SharedSessionContractImplementor getSession();

    public boolean isVeto();

    public Object getInstance();

    public String getEntityName();

    public Object[] getState();

    public EntityPersister getPersister();

    public boolean isExecuted();

    public boolean isVersionIncrementDisabled();

    public boolean areTransientReferencesNullified();

    public void setTransientReferencesNullified();

    public EntityKey getEntityKey();

    default public CompletionStage<Void> reactiveNullifyTransientReferencesIfNotAlready() {
        if (!this.areTransientReferencesNullified()) {
            return new ForeignKeys.Nullifier(this.getInstance(), false, this.isEarlyInsert(), (SessionImplementor)this.getSession(), this.getPersister()).nullifyTransientReferences(this.getState()).thenAccept(v -> {
                new Nullability(this.getSession()).checkNullability(this.getState(), this.getPersister(), false);
                this.setTransientReferencesNullified();
            });
        }
        return CompletionStages.voidFuture();
    }

    default public CompletionStage<Void> reactiveMakeEntityManaged() {
        return this.reactiveNullifyTransientReferencesIfNotAlready().thenAccept(v -> this.getSession().getPersistenceContextInternal().addEntity(this.getInstance(), this.getPersister().isMutable() ? Status.MANAGED : Status.READ_ONLY, this.getState(), this.getEntityKey(), Versioning.getVersion((Object[])this.getState(), (EntityPersister)this.getPersister()), LockMode.WRITE, this.isExecuted(), this.getPersister(), this.isVersionIncrementDisabled()));
    }

    default public CompletionStage<NonNullableTransientDependencies> reactiveFindNonNullableTransientEntities() {
        return ForeignKeys.findNonNullableTransientEntities(this.getPersister().getEntityName(), this.getInstance(), this.getState(), this.isEarlyInsert(), this.getSession());
    }
}

