/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.util.concurrent.CompletionStage;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.reactive.engine.ReactiveBeforeTransactionCompletionProcess;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;

public class ReactiveEntityIncrementVersionProcess
implements ReactiveBeforeTransactionCompletionProcess {
    private final Object object;

    public ReactiveEntityIncrementVersionProcess(Object object) {
        this.object = object;
    }

    @Override
    public CompletionStage<Void> doBeforeTransactionCompletion(ReactiveSession session) {
        EntityEntry entry = session.getPersistenceContext().getEntry(this.object);
        if (entry == null) {
            return CompletionStages.voidFuture();
        }
        return ((ReactiveEntityPersister)entry.getPersister()).lockReactive(entry.getId(), entry.getVersion(), this.object, new LockOptions(LockMode.PESSIMISTIC_FORCE_INCREMENT), (SharedSessionContractImplementor)session.getSharedContract());
    }
}

