/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.EntityIdentityInsertAction;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.engine.impl.ReactiveEntityInsertAction;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.spi.StatisticsImplementor;

public class ReactiveEntityIdentityInsertAction
extends EntityIdentityInsertAction
implements ReactiveEntityInsertAction {
    private final boolean isVersionIncrementDisabled;
    private boolean executed;
    private boolean transientReferencesNullified;

    public ReactiveEntityIdentityInsertAction(Object[] state, Object instance, EntityPersister persister, boolean isVersionIncrementDisabled, SharedSessionContractImplementor session, boolean isDelayed) {
        super(state, instance, persister, isVersionIncrementDisabled, session, isDelayed);
        this.isVersionIncrementDisabled = isVersionIncrementDisabled;
    }

    public void execute() throws HibernateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<Void> reactiveExecute() throws HibernateException {
        CompletionStage stage = this.reactiveNullifyTransientReferencesIfNotAlready();
        EntityPersister persister = this.getPersister();
        SharedSessionContractImplementor session = this.getSession();
        Object instance = this.getInstance();
        this.setVeto(this.preInsert());
        if (!this.isVeto()) {
            ReactiveEntityPersister reactivePersister = (ReactiveEntityPersister)persister;
            return stage.thenCompose(v -> reactivePersister.insertReactive(this.getState(), instance, session)).thenApply(this::applyGeneratedId).thenCompose(generatedId -> this.processInsertGenerated(reactivePersister, (Serializable)generatedId, instance, session).thenApply(v -> generatedId)).thenAccept(generatedId -> {
                persister.setIdentifier(instance, generatedId, session);
                PersistenceContext persistenceContext = session.getPersistenceContextInternal();
                persistenceContext.registerInsertedKey(this.getPersister(), generatedId);
                EntityKey entityKey = session.generateEntityKey(generatedId, persister);
                this.setEntityKey(entityKey);
                persistenceContext.checkUniqueness(entityKey, this.getInstance());
                this.postInsert();
                StatisticsImplementor statistics = session.getFactory().getStatistics();
                if (statistics.isStatisticsEnabled() && !this.isVeto()) {
                    statistics.insertEntity(this.getPersister().getEntityName());
                }
                this.markExecuted();
            });
        }
        this.postInsert();
        this.markExecuted();
        return stage;
    }

    private CompletionStage<Void> processInsertGenerated(ReactiveEntityPersister reactivePersister, Serializable generatedId, Object instance, SharedSessionContractImplementor session) {
        if (reactivePersister.hasInsertGeneratedProperties()) {
            return reactivePersister.reactiveProcessInsertGenerated(generatedId, instance, this.getState(), session);
        }
        return CompletionStages.voidFuture();
    }

    private Serializable applyGeneratedId(Serializable id) {
        this.setGeneratedId(id);
        return id;
    }

    @Override
    public EntityKey getEntityKey() {
        return super.getEntityKey();
    }

    protected void markExecuted() {
        super.markExecuted();
        this.executed = true;
    }

    @Override
    public boolean isExecuted() {
        return this.executed;
    }

    @Override
    public boolean isVersionIncrementDisabled() {
        return this.isVersionIncrementDisabled;
    }

    @Override
    public boolean areTransientReferencesNullified() {
        return this.transientReferencesNullified;
    }

    @Override
    public void setTransientReferencesNullified() {
        this.transientReferencesNullified = true;
    }
}

