/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.EntityDeleteAction;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.engine.ReactiveExecutable;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.spi.StatisticsImplementor;

public class ReactiveEntityDeleteAction
extends EntityDeleteAction
implements ReactiveExecutable {
    public ReactiveEntityDeleteAction(Serializable id, Object[] state, Object version, Object instance, EntityPersister persister, boolean isCascadeDeleteEnabled, SessionImplementor session) {
        super(id, state, version, instance, persister, isCascadeDeleteEnabled, session);
    }

    public void execute() throws HibernateException {
        throw new NotYetImplementedException();
    }

    @Override
    public CompletionStage<Void> reactiveExecute() throws HibernateException {
        Object ck;
        Serializable id = this.getId();
        EntityPersister persister = this.getPersister();
        SharedSessionContractImplementor session = this.getSession();
        Object instance = this.getInstance();
        boolean veto = this.preDelete();
        Object version = this.getVersion();
        if (persister.isVersionPropertyGenerated()) {
            version = persister.getVersion(instance);
        }
        if (persister.canWriteToCache()) {
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            ck = cache.generateCacheKey((Object)id, persister, session.getFactory(), session.getTenantIdentifier());
            this.setLock(cache.lockItem(session, ck, version));
        } else {
            ck = null;
        }
        CompletionStage<Void> deleteStep = !this.isCascadeDeleteEnabled() && !veto ? ((ReactiveEntityPersister)persister).deleteReactive(id, version, instance, session) : CompletionStages.voidFuture();
        return deleteStep.thenAccept(v -> {
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            EntityEntry entry = persistenceContext.removeEntry(instance);
            if (entry == null) {
                throw new AssertionFailure("possible non-threadsafe access to session");
            }
            entry.postDelete();
            persistenceContext.removeEntity(entry.getEntityKey());
            persistenceContext.removeProxy(entry.getEntityKey());
            if (persister.canWriteToCache()) {
                persister.getCacheAccessStrategy().remove(session, ck);
            }
            persistenceContext.getNaturalIdHelper().removeSharedNaturalIdCrossReference(persister, id, this.getNaturalIdValues());
            this.postDelete();
            StatisticsImplementor statistics = this.getSession().getFactory().getStatistics();
            if (statistics.isStatisticsEnabled() && !veto) {
                statistics.deleteEntity(this.getPersister().getEntityName());
            }
        });
    }
}

