/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletionStage;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionAction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostCollectionRecreateEvent;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEvent;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PreCollectionRecreateEvent;
import org.hibernate.event.spi.PreCollectionRecreateEventListener;
import org.hibernate.event.spi.PreCollectionUpdateEvent;
import org.hibernate.event.spi.PreCollectionUpdateEventListener;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.engine.ReactiveExecutable;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.collection.impl.ReactiveCollectionPersister;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.spi.StatisticsImplementor;

public class ReactiveCollectionUpdateAction
extends CollectionAction
implements ReactiveExecutable {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final boolean emptySnapshot;

    public ReactiveCollectionUpdateAction(PersistentCollection collection, CollectionPersister persister, Serializable key, boolean emptySnapshot, SharedSessionContractImplementor session) {
        super(persister, collection, key, session);
        this.emptySnapshot = emptySnapshot;
    }

    @Override
    public CompletionStage<Void> reactiveExecute() {
        Serializable key = this.getKey();
        SharedSessionContractImplementor session = this.getSession();
        ReactiveCollectionPersister reactivePersister = (ReactiveCollectionPersister)this.getPersister();
        CollectionPersister corePersister = this.getPersister();
        PersistentCollection collection = this.getCollection();
        boolean affectedByFilters = corePersister.isAffectedByEnabledFilters(session);
        this.preUpdate();
        CompletionStage<Void> updateStage = CompletionStages.voidFuture();
        if (!collection.wasInitialized()) {
            if (!collection.isDirty()) {
                throw new AssertionFailure("collection is not dirty");
            }
        } else if (!affectedByFilters && collection.empty()) {
            if (!this.emptySnapshot) {
                updateStage = updateStage.thenCompose(v -> reactivePersister.removeReactive(key, session)).thenAccept(count -> {});
            }
        } else {
            if (collection.needsRecreate(corePersister)) {
                if (affectedByFilters) {
                    throw LOG.cannotRecreateCollectionWhileFilterIsEnabled(MessageHelper.collectionInfoString((CollectionPersister)corePersister, (PersistentCollection)collection, (Serializable)key, (SharedSessionContractImplementor)session));
                }
                if (!this.emptySnapshot) {
                    updateStage = updateStage.thenCompose(v -> reactivePersister.removeReactive(key, session)).thenAccept(count -> {});
                }
                return updateStage.thenCompose(v -> reactivePersister.recreateReactive(collection, key, session).thenAccept(ignore -> {
                    session.getPersistenceContextInternal().getCollectionEntry(collection).afterAction(collection);
                    this.evict();
                    this.postUpdate();
                    StatisticsImplementor statistics = session.getFactory().getStatistics();
                    if (statistics.isStatisticsEnabled()) {
                        statistics.updateCollection(corePersister.getRole());
                    }
                }));
            }
            updateStage = updateStage.thenCompose(v -> reactivePersister.reactiveDeleteRows(collection, key, session)).thenCompose(v -> reactivePersister.reactiveUpdateRows(collection, key, session)).thenCompose(v -> reactivePersister.reactiveInsertRows(collection, key, session));
        }
        return updateStage.thenAccept(v -> {
            session.getPersistenceContextInternal().getCollectionEntry(collection).afterAction(collection);
            this.evict();
            this.postUpdate();
            StatisticsImplementor statistics = session.getFactory().getStatistics();
            if (statistics.isStatisticsEnabled()) {
                statistics.updateCollection(corePersister.getRole());
            }
        });
    }

    public void execute() throws HibernateException {
        throw new UnsupportedOperationException("Use reactiveExecute() instead");
    }

    private void preUpdate() {
        EventListenerGroup listenerGroup = this.listenerGroup(EventType.PRE_COLLECTION_UPDATE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PreCollectionUpdateEvent event = new PreCollectionUpdateEvent(this.getPersister(), this.getCollection(), this.eventSource());
        for (PreCollectionUpdateEventListener listener : listenerGroup.listeners()) {
            listener.onPreUpdateCollection(event);
        }
    }

    private void postUpdate() {
        EventListenerGroup listenerGroup = this.listenerGroup(EventType.POST_COLLECTION_UPDATE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostCollectionUpdateEvent event = new PostCollectionUpdateEvent(this.getPersister(), this.getCollection(), this.eventSource());
        for (PostCollectionUpdateEventListener listener : listenerGroup.listeners()) {
            listener.onPostUpdateCollection(event);
        }
    }

    private void preRecreate() {
        EventListenerGroup listenerGroup = this.listenerGroup(EventType.PRE_COLLECTION_RECREATE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PreCollectionRecreateEvent event = new PreCollectionRecreateEvent(this.getPersister(), this.getCollection(), this.eventSource());
        for (PreCollectionRecreateEventListener listener : listenerGroup.listeners()) {
            listener.onPreRecreateCollection(event);
        }
    }

    private void postRecreate() {
        EventListenerGroup listenerGroup = this.listenerGroup(EventType.POST_COLLECTION_RECREATE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostCollectionRecreateEvent event = new PostCollectionRecreateEvent(this.getPersister(), this.getCollection(), this.eventSource());
        for (PostCollectionRecreateEventListener listener : listenerGroup.listeners()) {
            listener.onPostRecreateCollection(event);
        }
    }
}

