/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionAction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostCollectionRecreateEvent;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEvent;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PreCollectionRecreateEvent;
import org.hibernate.event.spi.PreCollectionRecreateEventListener;
import org.hibernate.event.spi.PreCollectionRemoveEvent;
import org.hibernate.event.spi.PreCollectionRemoveEventListener;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.reactive.engine.ReactiveExecutable;
import org.hibernate.reactive.persister.collection.impl.ReactiveCollectionPersister;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.spi.StatisticsImplementor;

public class ReactiveCollectionRemoveAction
extends CollectionAction
implements ReactiveExecutable {
    private final Object affectedOwner;
    private final boolean emptySnapshot;

    public ReactiveCollectionRemoveAction(PersistentCollection collection, CollectionPersister persister, Serializable key, boolean emptySnapshot, SharedSessionContractImplementor session) {
        super(persister, collection, key, session);
        if (collection == null) {
            throw new AssertionFailure("collection == null");
        }
        this.emptySnapshot = emptySnapshot;
        this.affectedOwner = session.getPersistenceContextInternal().getLoadedCollectionOwnerOrNull(collection);
    }

    @Override
    public CompletionStage<Void> reactiveExecute() {
        Serializable key = this.getKey();
        SharedSessionContractImplementor session = this.getSession();
        ReactiveCollectionPersister reactivePersister = (ReactiveCollectionPersister)this.getPersister();
        CollectionPersister corePersister = this.getPersister();
        PersistentCollection collection = this.getCollection();
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        CompletionStage<Void> removeStage = CompletionStages.voidFuture();
        if (!this.emptySnapshot) {
            removeStage = removeStage.thenAccept(v -> this.preRemove()).thenCompose(v -> reactivePersister.removeReactive(key, session).thenAccept(ignore -> {
                this.evict();
                this.postRemove();
            }));
        }
        if (collection != null) {
            return removeStage.thenAccept(v -> {
                session.getPersistenceContextInternal().getCollectionEntry(collection).afterAction(collection);
                this.evict();
                this.postRemove();
                if (statistics.isStatisticsEnabled()) {
                    statistics.updateCollection(corePersister.getRole());
                }
            });
        }
        return removeStage.thenAccept(v -> {
            this.evict();
            this.postRemove();
            if (statistics.isStatisticsEnabled()) {
                statistics.updateCollection(corePersister.getRole());
            }
        });
    }

    public void execute() throws HibernateException {
        throw new UnsupportedOperationException("Use reactiveExecute() instead");
    }

    private void preRemove() {
        EventListenerGroup listenerGroup = this.listenerGroup(EventType.PRE_COLLECTION_REMOVE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PreCollectionRemoveEvent event = new PreCollectionRemoveEvent(this.getPersister(), this.getCollection(), this.eventSource(), this.affectedOwner);
        for (PreCollectionRemoveEventListener listener : listenerGroup.listeners()) {
            listener.onPreRemoveCollection(event);
        }
    }

    private void postRemove() {
        EventListenerGroup listenerGroup = this.listenerGroup(EventType.POST_COLLECTION_REMOVE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostCollectionRemoveEvent event = new PostCollectionRemoveEvent(this.getPersister(), this.getCollection(), this.eventSource(), this.affectedOwner);
        for (PostCollectionRemoveEventListener listener : listenerGroup.listeners()) {
            listener.onPostRemoveCollection(event);
        }
    }

    private void preRecreate() {
        EventListenerGroup listenerGroup = this.listenerGroup(EventType.PRE_COLLECTION_RECREATE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PreCollectionRecreateEvent event = new PreCollectionRecreateEvent(this.getPersister(), this.getCollection(), this.eventSource());
        for (PreCollectionRecreateEventListener listener : listenerGroup.listeners()) {
            listener.onPreRecreateCollection(event);
        }
    }

    private void postRecreate() {
        EventListenerGroup listenerGroup = this.listenerGroup(EventType.POST_COLLECTION_RECREATE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostCollectionRecreateEvent event = new PostCollectionRecreateEvent(this.getPersister(), this.getCollection(), this.eventSource());
        for (PostCollectionRecreateEventListener listener : listenerGroup.listeners()) {
            listener.onPostRecreateCollection(event);
        }
    }
}

