/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionAction;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostCollectionRecreateEvent;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PreCollectionRecreateEvent;
import org.hibernate.event.spi.PreCollectionRecreateEventListener;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.reactive.engine.ReactiveExecutable;
import org.hibernate.reactive.persister.collection.impl.ReactiveCollectionPersister;

public class ReactiveCollectionRecreateAction
extends CollectionAction
implements ReactiveExecutable {
    public ReactiveCollectionRecreateAction(PersistentCollection collection, CollectionPersister persister, Serializable key, SharedSessionContractImplementor session) {
        super(persister, collection, key, session);
    }

    @Override
    public CompletionStage<Void> reactiveExecute() {
        ReactiveCollectionPersister persister = (ReactiveCollectionPersister)this.getPersister();
        SharedSessionContractImplementor session = this.getSession();
        Serializable key = this.getKey();
        PersistentCollection collection = this.getCollection();
        this.preRecreate();
        return persister.recreateReactive(collection, key, session).thenAccept(v -> {
            session.getPersistenceContextInternal().getCollectionEntry(collection).afterAction(collection);
            this.evict();
            this.postRecreate();
        });
    }

    public void execute() throws HibernateException {
        throw new UnsupportedOperationException("Use reactiveExecute() instead");
    }

    private void preRecreate() {
        EventListenerGroup listenerGroup = this.listenerGroup(EventType.PRE_COLLECTION_RECREATE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PreCollectionRecreateEvent event = new PreCollectionRecreateEvent(this.getPersister(), this.getCollection(), this.eventSource());
        for (PreCollectionRecreateEventListener listener : listenerGroup.listeners()) {
            listener.onPreRecreateCollection(event);
        }
    }

    private void postRecreate() {
        EventListenerGroup listenerGroup = this.listenerGroup(EventType.POST_COLLECTION_RECREATE);
        if (listenerGroup.isEmpty()) {
            return;
        }
        PostCollectionRecreateEvent event = new PostCollectionRecreateEvent(this.getPersister(), this.getCollection(), this.eventSource());
        for (PostCollectionRecreateEventListener listener : listenerGroup.listeners()) {
            listener.onPostRecreateCollection(event);
        }
    }
}

