/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.TransientObjectException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.internal.NonNullableTransientDependencies;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.reactive.engine.impl.ReactivePersistenceContextAdapter;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public final class ForeignKeys {
    public static CompletionStage<Boolean> isNotTransient(String entityName, Object entity, Boolean assumed, SessionImplementor session) {
        if (entity instanceof HibernateProxy) {
            return CompletionStages.trueFuture();
        }
        if (session.getPersistenceContextInternal().isEntryFor(entity)) {
            return CompletionStages.trueFuture();
        }
        return ForeignKeys.isTransient(entityName, entity, assumed, session).thenApply(trans -> trans == false);
    }

    public static CompletionStage<Boolean> isTransient(String entityName, Object entity, Boolean assumed, SessionImplementor session) {
        if (entity == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
            return CompletionStages.falseFuture();
        }
        Boolean isUnsaved = session.getInterceptor().isTransient(entity);
        if (isUnsaved != null) {
            return CompletionStages.completedFuture(isUnsaved);
        }
        EntityPersister persister = session.getEntityPersister(entityName, entity);
        isUnsaved = persister.isTransient(entity, (SharedSessionContractImplementor)session);
        if (isUnsaved != null) {
            return CompletionStages.completedFuture(isUnsaved);
        }
        if (assumed != null) {
            return CompletionStages.completedFuture(assumed);
        }
        ReactivePersistenceContextAdapter persistenceContext = (ReactivePersistenceContextAdapter)session.getPersistenceContextInternal();
        Serializable id = persister.getIdentifier(entity, (SharedSessionContractImplementor)session);
        return persistenceContext.reactiveGetDatabaseSnapshot(id, persister).thenApply(Objects::isNull);
    }

    public static CompletionStage<Object> getEntityIdentifierIfNotUnsaved(String entityName, Object object, SessionImplementor session) throws TransientObjectException {
        if (object == null) {
            return CompletionStages.nullFuture();
        }
        Serializable id = session.getContextEntityIdentifier(object);
        if (id == null) {
            return ForeignKeys.isTransient(entityName, object, Boolean.FALSE, session).thenApply(trans -> {
                if (trans.booleanValue()) {
                    throw new TransientObjectException("object references an unsaved transient instance - save the transient instance before flushing: " + (entityName == null ? session.guessEntityName(object) : entityName));
                }
                return session.getEntityPersister(entityName, object).getIdentifier(object, (SharedSessionContractImplementor)session);
            });
        }
        return CompletionStages.completedFuture(id);
    }

    public static CompletionStage<NonNullableTransientDependencies> findNonNullableTransientEntities(String entityName, Object entity, Object[] values, boolean isEarlyInsert, SharedSessionContractImplementor session) {
        EntityPersister persister = session.getEntityPersister(entityName, entity);
        Type[] types = persister.getPropertyTypes();
        Nullifier nullifier = new Nullifier(entity, false, isEarlyInsert, (SessionImplementor)session, persister);
        String[] propertyNames = persister.getPropertyNames();
        boolean[] nullability = persister.getPropertyNullability();
        NonNullableTransientDependencies nonNullableTransientEntities = new NonNullableTransientDependencies();
        return CompletionStages.loop(0, types.length, i -> ForeignKeys.collectNonNullableTransientEntities(nullifier, values[i], propertyNames[i], types[i], nullability[i], session, nonNullableTransientEntities)).thenApply(r -> nonNullableTransientEntities.isEmpty() ? null : nonNullableTransientEntities);
    }

    private static CompletionStage<Void> collectNonNullableTransientEntities(Nullifier nullifier, Object value, String propertyName, Type type, boolean isNullable, SharedSessionContractImplementor session, NonNullableTransientDependencies nonNullableTransientEntities) {
        CompositeType actype;
        boolean[] subValueNullability;
        if (value == null) {
            return CompletionStages.voidFuture();
        }
        if (type.isEntityType()) {
            EntityType entityType = (EntityType)type;
            if (!isNullable && !entityType.isOneToOne()) {
                return nullifier.isNullifiable(entityType.getAssociatedEntityName(), value).thenAccept(isNullifiable -> {
                    if (isNullifiable.booleanValue()) {
                        nonNullableTransientEntities.add(propertyName, value);
                    }
                });
            }
        } else if (type.isAnyType()) {
            if (!isNullable) {
                return nullifier.isNullifiable(null, value).thenAccept(isNullifiable -> {
                    if (isNullifiable.booleanValue()) {
                        nonNullableTransientEntities.add(propertyName, value);
                    }
                });
            }
        } else if (type.isComponentType() && (subValueNullability = (actype = (CompositeType)type).getPropertyNullability()) != null) {
            String[] subPropertyNames = actype.getPropertyNames();
            Object[] subvalues = actype.getPropertyValues(value, session);
            Type[] subtypes = actype.getSubtypes();
            return CompletionStages.loop(0, subtypes.length, i -> ForeignKeys.collectNonNullableTransientEntities(nullifier, subvalues[i], subPropertyNames[i], subtypes[i], subValueNullability[i], session, nonNullableTransientEntities));
        }
        return CompletionStages.voidFuture();
    }

    private ForeignKeys() {
    }

    public static class Nullifier {
        private final boolean isDelete;
        private final boolean isEarlyInsert;
        private final SessionImplementor session;
        private final Object self;
        private final EntityPersister persister;

        public Nullifier(Object self, boolean isDelete, boolean isEarlyInsert, SessionImplementor session, EntityPersister persister) {
            this.isDelete = isDelete;
            this.isEarlyInsert = isEarlyInsert;
            this.session = session;
            this.persister = persister;
            this.self = self;
        }

        public CompletionStage<Void> nullifyTransientReferences(Object[] values) {
            CompletionStage<Void> result = this.nullifyTransientReferences(null, values, this.persister.getPropertyTypes(), this.persister.getPropertyNames());
            return result == null ? CompletionStages.voidFuture() : result;
        }

        private CompletionStage<Object> nullifyTransientReferences(Object value, String propertyName, Type type) {
            CompletionStage<Object> result;
            if (value == null) {
                return null;
            }
            if (type.isEntityType()) {
                EntityType entityType = (EntityType)type;
                if (entityType.isOneToOne()) {
                    return null;
                }
                if (this.isDelete && value == LazyPropertyInitializer.UNFETCHED_PROPERTY && !this.session.getPersistenceContextInternal().isNullifiableEntityKeysEmpty()) {
                    throw new UnsupportedOperationException("lazy property initialization not supported");
                }
                CompletionStage<Object> fetcher = CompletionStages.completedFuture(value);
                result = fetcher.thenCompose(fetchedValue -> {
                    if (fetchedValue == null) {
                        return CompletionStages.nullFuture();
                    }
                    return this.isNullifiable(entityType.getAssociatedEntityName(), fetchedValue).thenApply(trans -> trans != false ? null : fetchedValue);
                });
            } else if (type.isAnyType()) {
                result = this.isNullifiable(null, value).thenApply(trans -> trans != false ? null : value);
            } else if (type.isComponentType()) {
                CompositeType actype = (CompositeType)type;
                Object[] values = actype.getPropertyValues(value, (SharedSessionContractImplementor)this.session);
                CompletionStage<Void> nullifier = this.nullifyTransientReferences(propertyName, values, actype.getSubtypes(), actype.getPropertyNames());
                if (nullifier == null) {
                    return null;
                }
                result = nullifier.thenAccept(v -> actype.setPropertyValues(value, values, EntityMode.POJO)).thenApply(v -> value);
            } else {
                return null;
            }
            return result.thenApply(returnedValue -> {
                this.trackDirt(value, propertyName, returnedValue);
                return returnedValue;
            });
        }

        private CompletionStage<Void> nullifyTransientReferences(String propertyName, Object[] values, Type[] types, String[] names) {
            CompletionStage<Void> nullifiers = null;
            for (int i = 0; i < values.length; ++i) {
                int ii = i;
                String name = propertyName == null ? names[ii] : StringHelper.qualify((String)propertyName, (String)names[ii]);
                CompletionStage<Object> nullifier = this.nullifyTransientReferences(values[ii], name, types[ii]);
                if (nullifier == null) continue;
                nullifiers = (nullifiers == null ? nullifier : nullifiers.thenCompose(v -> nullifier)).thenAccept(replacement -> {
                    values[ii] = replacement;
                });
            }
            return nullifiers;
        }

        private void trackDirt(Object value, String propertyName, Object returnedValue) {
            if (value != returnedValue && returnedValue == null && this.self instanceof SelfDirtinessTracker) {
                ((SelfDirtinessTracker)this.self).$$_hibernate_trackChange(propertyName);
            }
        }

        private CompletionStage<Boolean> isNullifiable(String entityName, Object object) throws HibernateException {
            if (object == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                return CompletionStages.falseFuture();
            }
            if (object instanceof HibernateProxy) {
                LazyInitializer li = ((HibernateProxy)object).getHibernateLazyInitializer();
                if (li.getImplementation((SharedSessionContractImplementor)this.session) == null) {
                    return CompletionStages.falseFuture();
                }
                object = li.getImplementation((SharedSessionContractImplementor)this.session);
            }
            if (object == this.self) {
                return CompletionStages.completedFuture(this.isEarlyInsert || this.isDelete && this.session.getJdbcServices().getDialect().hasSelfReferentialForeignKeyBug());
            }
            EntityEntry entityEntry = this.session.getPersistenceContextInternal().getEntry(object);
            if (entityEntry == null) {
                return ForeignKeys.isTransient(entityName, object, null, this.session);
            }
            return CompletionStages.completedFuture(entityEntry.isNullifiable(this.isEarlyInsert, (SharedSessionContractImplementor)this.session));
        }
    }
}

