/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.internal.PropertyAccessStrategyBackRefImpl;
import org.hibernate.reactive.engine.impl.ForeignKeys;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.session.ReactiveQueryExecutor;
import org.hibernate.reactive.session.impl.ReactiveSessionImpl;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;

public class EntityTypes {
    public static CompletionStage<Object> resolve(EntityType entityType, Object idOrUniqueKey, Object owner, SharedSessionContractImplementor session) {
        if (idOrUniqueKey != null && !EntityTypes.isNull(entityType, owner, session)) {
            if (entityType.isReferenceToPrimaryKey()) {
                return ((ReactiveQueryExecutor)session).reactiveInternalLoad(entityType.getAssociatedEntityName(), (Serializable)idOrUniqueKey, true, entityType.isNullable());
            }
            return EntityTypes.loadByUniqueKey(entityType, idOrUniqueKey, session);
        }
        return null;
    }

    static boolean isNull(EntityType entityType, Object owner, SharedSessionContractImplementor session) {
        if (entityType instanceof OneToOneType) {
            OneToOneType type = (OneToOneType)entityType;
            String propertyName = type.getPropertyName();
            if (propertyName != null) {
                EntityPersister ownerPersister = session.getFactory().getMetamodel().entityPersister(entityType.getAssociatedEntityName());
                Serializable id = session.getContextEntityIdentifier(owner);
                EntityKey entityKey = session.generateEntityKey(id, ownerPersister);
                return session.getPersistenceContextInternal().isPropertyNull(entityKey, propertyName);
            }
            return false;
        }
        return false;
    }

    static CompletionStage<Object> loadByUniqueKey(EntityType entityType, Object key, SharedSessionContractImplementor session) throws HibernateException {
        SessionFactoryImplementor factory = session.getFactory();
        String entityName = entityType.getAssociatedEntityName();
        String uniqueKeyPropertyName = entityType.getRHSUniqueKeyPropertyName();
        ReactiveEntityPersister persister = (ReactiveEntityPersister)factory.getMetamodel().entityPersister(entityName);
        EntityUniqueKey euk = new EntityUniqueKey(entityName, uniqueKeyPropertyName, key, entityType.getIdentifierOrUniqueKeyType((Mapping)factory), persister.getEntityMode(), factory);
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        Object result = persistenceContext.getEntity(euk);
        if (result != null) {
            return CompletionStages.completedFuture(persistenceContext.proxyFor(result));
        }
        return persister.reactiveLoadByUniqueKey(uniqueKeyPropertyName, key, session).thenApply(loaded -> {
            if (loaded != null) {
                persistenceContext.addEntity(euk, loaded);
            }
            return loaded;
        });
    }

    public static CompletionStage<Object[]> replace(Object[] original, Object[] target, Type[] types, SessionImplementor session, Object owner, Map copyCache) {
        Object[] copied = new Object[original.length];
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (original[i2] == LazyPropertyInitializer.UNFETCHED_PROPERTY || original[i2] == PropertyAccessStrategyBackRefImpl.UNKNOWN) {
                copied[i2] = target[i2];
                continue;
            }
            if (types[i2] instanceof EntityType) continue;
            copied[i2] = types[i2].replace(original[i2], target[i2] == LazyPropertyInitializer.UNFETCHED_PROPERTY ? null : target[i2], (SharedSessionContractImplementor)session, owner, copyCache);
        }
        return CompletionStages.loop(0, types.length, i -> original[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY && original[i] != PropertyAccessStrategyBackRefImpl.UNKNOWN && types[i] instanceof EntityType, i -> EntityTypes.replace((EntityType)types[i], original[i], target[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY ? null : target[i], session, owner, copyCache).thenAccept(copy -> {
            copied[i] = copy;
        })).thenApply(v -> copied);
    }

    public static CompletionStage<Object[]> replace(Object[] original, Object[] target, Type[] types, SessionImplementor session, Object owner, Map copyCache, ForeignKeyDirection foreignKeyDirection) {
        Object[] copied = new Object[original.length];
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (original[i2] == LazyPropertyInitializer.UNFETCHED_PROPERTY || original[i2] == PropertyAccessStrategyBackRefImpl.UNKNOWN) {
                copied[i2] = target[i2];
                continue;
            }
            if (types[i2] instanceof EntityType) continue;
            copied[i2] = types[i2].replace(original[i2], target[i2] == LazyPropertyInitializer.UNFETCHED_PROPERTY ? null : target[i2], (SharedSessionContractImplementor)session, owner, copyCache, foreignKeyDirection);
        }
        return CompletionStages.loop(0, types.length, i -> original[i] != LazyPropertyInitializer.UNFETCHED_PROPERTY && original[i] != PropertyAccessStrategyBackRefImpl.UNKNOWN && types[i] instanceof EntityType, i -> EntityTypes.replace((EntityType)types[i], original[i], target[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY ? null : target[i], session, owner, copyCache, foreignKeyDirection).thenAccept(copy -> {
            copied[i] = copy;
        })).thenApply(v -> copied);
    }

    private static CompletionStage<Object> replace(EntityType entityType, Object original, Object target, SessionImplementor session, Object owner, Map copyCache, ForeignKeyDirection foreignKeyDirection) throws HibernateException {
        boolean include = entityType.isAssociationType() ? entityType.getForeignKeyDirection() == foreignKeyDirection : ForeignKeyDirection.FROM_PARENT == foreignKeyDirection;
        return include ? EntityTypes.replace(entityType, original, target, session, owner, copyCache) : CompletionStages.completedFuture(target);
    }

    private static CompletionStage<Object> replace(EntityType entityType, Object original, Object target, SessionImplementor session, Object owner, Map copyCache) {
        if (original == null) {
            return CompletionStages.nullFuture();
        }
        Object cached = copyCache.get(original);
        if (cached != null) {
            return CompletionStages.completedFuture(cached);
        }
        if (original == target) {
            return CompletionStages.completedFuture(target);
        }
        if (session.getContextEntityIdentifier(original) == null) {
            return ForeignKeys.isTransient(entityType.getAssociatedEntityName(), original, false, session).thenCompose(isTransient -> {
                if (isTransient.booleanValue()) {
                    if (copyCache.containsValue(original)) {
                        return CompletionStages.completedFuture(original);
                    }
                    Object copy = session.getEntityPersister(entityType.getAssociatedEntityName(), original).instantiate(null, (SharedSessionContractImplementor)session);
                    copyCache.put(original, copy);
                    return CompletionStages.completedFuture(copy);
                }
                return EntityTypes.resolveIdOrUniqueKey(entityType, original, session, owner, copyCache);
            });
        }
        return EntityTypes.resolveIdOrUniqueKey(entityType, original, session, owner, copyCache);
    }

    private static CompletionStage<Object> resolveIdOrUniqueKey(EntityType entityType, Object original, SessionImplementor session, Object owner, Map copyCache) {
        return EntityTypes.getIdentifier(entityType, original, session).thenCompose(id -> {
            if (id == null) {
                throw new AssertionFailure("non-transient entity has a null id: " + original.getClass().getName());
            }
            return ((ReactiveSessionImpl)session).reactiveFetch(id, true).thenCompose(fetched -> {
                Object idOrUniqueKey = entityType.getIdentifierOrUniqueKeyType((Mapping)session.getFactory()).replace(fetched, null, (SharedSessionContractImplementor)session, owner, copyCache);
                return EntityTypes.resolve(entityType, idOrUniqueKey, owner, (SharedSessionContractImplementor)session);
            });
        });
    }

    private static CompletionStage<Object> getIdentifier(EntityType entityType, Object value, SessionImplementor session) {
        if (entityType.isReferenceToIdentifierProperty()) {
            return ForeignKeys.getEntityIdentifierIfNotUnsaved(entityType.getAssociatedEntityName(), value, session);
        }
        if (value == null) {
            return CompletionStages.nullFuture();
        }
        EntityPersister entityPersister = entityType.getAssociatedEntityPersister(session.getFactory());
        String uniqueKeyPropertyName = entityType.getRHSUniqueKeyPropertyName();
        CompletionStage<Object> propertyValue = entityPersister.getPropertyValue(value, uniqueKeyPropertyName);
        Type type = entityPersister.getPropertyType(uniqueKeyPropertyName);
        if (type.isEntityType()) {
            propertyValue = EntityTypes.getIdentifier((EntityType)type, propertyValue, session);
        }
        return CompletionStages.completedFuture(propertyValue);
    }
}

