/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.TransientPropertyValueException;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.internal.MergeContext;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.reactive.engine.impl.CascadingAction;
import org.hibernate.reactive.engine.impl.ForeignKeys;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class CascadingActions {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    public static final CascadingAction<IdentitySet> DELETE = new BaseCascadingAction<IdentitySet>(org.hibernate.engine.spi.CascadingActions.DELETE){

        @Override
        public CompletionStage<Void> cascade(EventSource session, Object child, String entityName, IdentitySet context, boolean isCascadeDeleteEnabled) {
            LOG.tracev("Cascading to delete: {0}", entityName);
            return ((ReactiveSession)session.unwrap(ReactiveSession.class)).reactiveFetch(child, true).thenCompose(c -> ((ReactiveSession)session.unwrap(ReactiveSession.class)).reactiveRemove(c, isCascadeDeleteEnabled, context));
        }
    };
    public static final CascadingAction<IdentitySet> PERSIST = new BaseCascadingAction<IdentitySet>(org.hibernate.engine.spi.CascadingActions.PERSIST){

        @Override
        public CompletionStage<Void> cascade(EventSource session, Object child, String entityName, IdentitySet context, boolean isCascadeDeleteEnabled) throws HibernateException {
            LOG.tracev("Cascading to persist: {0}", entityName);
            return ((ReactiveSession)session.unwrap(ReactiveSession.class)).reactivePersist(child, context);
        }
    };
    public static final CascadingAction<IdentitySet> PERSIST_ON_FLUSH = new BaseCascadingAction<IdentitySet>(org.hibernate.engine.spi.CascadingActions.PERSIST_ON_FLUSH){

        @Override
        public CompletionStage<Void> cascade(EventSource session, Object child, String entityName, IdentitySet context, boolean isCascadeDeleteEnabled) throws HibernateException {
            LOG.tracev("Cascading to persist on flush: {0}", entityName);
            return ((ReactiveSession)session.unwrap(ReactiveSession.class)).reactivePersistOnFlush(child, context);
        }

        private boolean isInManagedState(Object child, EventSource session) {
            EntityEntry entry = session.getPersistenceContextInternal().getEntry(child);
            return entry != null && (entry.getStatus() == Status.MANAGED || entry.getStatus() == Status.READ_ONLY || entry.getStatus() == Status.SAVING);
        }

        @Override
        public CompletionStage<Void> noCascade(EventSource session, Object parent, EntityPersister persister, Type propertyType, int propertyIndex) {
            Object child;
            if (propertyType.isEntityType() && (child = persister.getPropertyValue(parent, propertyIndex)) != null && !this.isInManagedState(child, session) && !(child instanceof HibernateProxy)) {
                String childEntityName = ((EntityType)propertyType).getAssociatedEntityName(session.getFactory());
                return ForeignKeys.isTransient(childEntityName, child, null, (SessionImplementor)session).thenAccept(isTrans -> {
                    if (isTrans.booleanValue()) {
                        String parentEntityName = persister.getEntityName();
                        String propertyName = persister.getPropertyNames()[propertyIndex];
                        throw new TransientPropertyValueException("object references an unsaved transient instance - save the transient instance before flushing", childEntityName, parentEntityName, propertyName);
                    }
                });
            }
            return CompletionStages.voidFuture();
        }
    };
    public static final CascadingAction<MergeContext> MERGE = new BaseCascadingAction<MergeContext>(org.hibernate.engine.spi.CascadingActions.MERGE){

        @Override
        public CompletionStage<Void> cascade(EventSource session, Object child, String entityName, MergeContext context, boolean isCascadeDeleteEnabled) throws HibernateException {
            LOG.tracev("Cascading to refresh: {0}", entityName);
            return ((ReactiveSession)session.unwrap(ReactiveSession.class)).reactiveMerge(child, context);
        }
    };
    public static final CascadingAction<IdentitySet> REFRESH = new BaseCascadingAction<IdentitySet>(org.hibernate.engine.spi.CascadingActions.REFRESH){

        @Override
        public CompletionStage<Void> cascade(EventSource session, Object child, String entityName, IdentitySet context, boolean isCascadeDeleteEnabled) throws HibernateException {
            LOG.tracev("Cascading to refresh: {0}", entityName);
            return ((ReactiveSession)session.unwrap(ReactiveSession.class)).reactiveRefresh(child, context);
        }
    };
    public static final CascadingAction<LockOptions> LOCK = new BaseCascadingAction<LockOptions>(org.hibernate.engine.spi.CascadingActions.LOCK){

        @Override
        public CompletionStage<Void> cascade(EventSource session, Object child, String entityName, LockOptions context, boolean isCascadeDeleteEnabled) throws HibernateException {
            LOG.tracev("Cascading to lock: {0}", entityName);
            return ((ReactiveSession)session.unwrap(ReactiveSession.class)).reactiveLock(child, context);
        }
    };

    private CascadingActions() {
    }

    public static abstract class BaseCascadingAction<C>
    implements CascadingAction<C> {
        private final org.hibernate.engine.spi.CascadingAction delegate;

        BaseCascadingAction(org.hibernate.engine.spi.CascadingAction delegate) {
            this.delegate = delegate;
        }

        @Override
        public Iterator<?> getCascadableChildrenIterator(EventSource session, CollectionType collectionType, Object collection) {
            return this.delegate.getCascadableChildrenIterator(session, collectionType, collection);
        }

        @Override
        public boolean deleteOrphans() {
            return this.delegate.deleteOrphans();
        }

        @Override
        public org.hibernate.engine.spi.CascadingAction delegate() {
            return this.delegate;
        }

        @Override
        public boolean requiresNoCascadeChecking() {
            return this.delegate.requiresNoCascadeChecking();
        }

        @Override
        public CompletionStage<Void> noCascade(EventSource session, Object parent, EntityPersister persister, Type propertyType, int propertyIndex) {
            return CompletionStages.voidFuture();
        }

        @Override
        public boolean performOnLazyProperty() {
            return this.delegate.performOnLazyProperty();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

