/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.bulk.impl;

import org.hibernate.dialect.DB297Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MariaDB103Dialect;
import org.hibernate.dialect.MySQL8Dialect;
import org.hibernate.dialect.PostgreSQL10Dialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.hql.spi.id.IdTableSupportStandardImpl;

class ReactiveIdTableSupport
extends IdTableSupportStandardImpl {
    private final Dialect dialect;

    public ReactiveIdTableSupport(Dialect dialect) {
        this.dialect = dialect;
    }

    public String generateIdTableName(String baseName) {
        return (this.dialect instanceof SQLServerDialect ? "#" : "ht_") + baseName;
    }

    public String getCreateIdTableCommand() {
        if (this.dialect instanceof PostgreSQL10Dialect) {
            return "create temporary table";
        }
        if (this.dialect instanceof MySQL8Dialect || this.dialect instanceof MariaDB103Dialect) {
            return "create temporary table if not exists";
        }
        if (this.dialect instanceof DB297Dialect) {
            return "create global temporary table";
        }
        if (this.dialect instanceof SQLServerDialect) {
            return "create table";
        }
        return "create local temporary table";
    }

    public String getDropIdTableCommand() {
        if (this.dialect instanceof PostgreSQL10Dialect) {
            return "drop table";
        }
        if (this.dialect instanceof MySQL8Dialect) {
            return "drop temporary table";
        }
        if (this.dialect instanceof DB297Dialect) {
            return "drop table";
        }
        return "drop table";
    }

    public String getCreateIdTableStatementOptions() {
        if (this.dialect instanceof DB297Dialect) {
            return "not logged";
        }
        return null;
    }
}

