/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.bulk.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.dialect.DB297Dialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.tree.AbstractRestrictableStatement;
import org.hibernate.hql.internal.ast.tree.AssignmentSpecification;
import org.hibernate.hql.internal.ast.tree.DeleteStatement;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.UpdateStatement;
import org.hibernate.hql.spi.id.AbstractMultiTableBulkIdStrategyImpl;
import org.hibernate.hql.spi.id.AbstractTableBasedBulkIdHandler;
import org.hibernate.hql.spi.id.IdTableInfo;
import org.hibernate.hql.spi.id.IdTableSupport;
import org.hibernate.hql.spi.id.MultiTableBulkIdStrategy;
import org.hibernate.hql.spi.id.local.IdTableInfoImpl;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.reactive.bulk.StatementsWithParameters;
import org.hibernate.reactive.bulk.impl.ReactiveIdTableSupport;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.pool.ReactiveConnectionPool;
import org.hibernate.reactive.pool.impl.Parameters;
import org.hibernate.reactive.session.ReactiveQueryExecutor;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.Delete;
import org.hibernate.sql.Update;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public class ReactiveBulkIdStrategy
extends AbstractMultiTableBulkIdStrategyImpl<IdTableInfoImpl, AbstractMultiTableBulkIdStrategyImpl.PreparationContext>
implements MultiTableBulkIdStrategy {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ReactiveBulkIdStrategy.class);
    private static final ParameterSpecification[] NO_PARAMS = new ParameterSpecification[0];
    private final boolean db2;
    private final Set<String> createdGlobalTemporaryTables = new HashSet<String>();
    private final List<String> dropGlobalTemporaryTables = new ArrayList<String>();
    private final Parameters parameters;
    private StandardServiceRegistry serviceRegistry;

    public ReactiveBulkIdStrategy(MetadataImplementor metadata) {
        this(metadata.getDatabase().getDialect());
    }

    ReactiveBulkIdStrategy(Dialect dialect) {
        super((IdTableSupport)new ReactiveIdTableSupport(dialect));
        this.db2 = dialect instanceof DB297Dialect;
        this.parameters = Parameters.instance(dialect);
    }

    protected void initialize(MetadataBuildingOptions buildingOptions, SessionFactoryOptions sessionFactoryOptions) {
        this.serviceRegistry = buildingOptions.getServiceRegistry();
    }

    protected IdTableInfoImpl buildIdTableInfo(PersistentClass entityBinding, Table idTable, JdbcServices jdbcServices, MetadataImplementor metadata, AbstractMultiTableBulkIdStrategyImpl.PreparationContext context, SqlStringGenerationContext sqlStringGenerationContext) {
        return new IdTableInfoImpl(jdbcServices.getJdbcEnvironment().getQualifiedObjectNameFormatter().format(idTable.getQualifiedTableName(), jdbcServices.getJdbcEnvironment().getDialect()), this.buildIdTableCreateStatement(idTable, metadata, sqlStringGenerationContext), this.buildIdTableDropStatement(idTable, sqlStringGenerationContext));
    }

    public void release(JdbcServices jdbcServices, JdbcConnectionAccess connectionAccess) {
        boolean dropIdTables;
        if (this.serviceRegistry != null && !this.dropGlobalTemporaryTables.isEmpty() && (dropIdTables = ((Boolean)((ConfigurationService)this.serviceRegistry.getService(ConfigurationService.class)).getSetting("hibernate.hql.bulk_id_strategy.global_temporary.drop_tables", StandardConverters.BOOLEAN, (Object)false)).booleanValue())) {
            ReactiveConnection connection = ((ReactiveConnectionPool)this.serviceRegistry.getService(ReactiveConnectionPool.class)).getProxyConnection();
            CompletionStages.loop(this.dropGlobalTemporaryTables, connection::execute).whenComplete((v, e) -> connection.close()).handle(CompletionStages::ignoreErrors).toCompletableFuture().join();
        }
    }

    public MultiTableBulkIdStrategy.UpdateHandler buildUpdateHandler(SessionFactoryImplementor factory, HqlSqlWalker walker) {
        return new TableBasedUpdateHandlerImpl(factory, walker, this.targetedPersister(walker));
    }

    public MultiTableBulkIdStrategy.DeleteHandler buildDeleteHandler(SessionFactoryImplementor factory, HqlSqlWalker walker) {
        return new TableBasedDeleteHandlerImpl(factory, walker, this.targetedPersister(walker));
    }

    private Queryable targetedPersister(HqlSqlWalker walker) {
        AbstractRestrictableStatement restrictableStatement = (AbstractRestrictableStatement)walker.getAST();
        FromElement fromElement = restrictableStatement.getFromClause().getFromElement();
        return fromElement.getQueryable();
    }

    private class TableBasedDeleteHandlerImpl
    extends TempTableHandler
    implements MultiTableBulkIdStrategy.DeleteHandler {
        private final String[] statements;
        private final ParameterSpecification[][] parameterSpecifications;

        @Override
        public ParameterSpecification[][] getParameterSpecifications() {
            return this.parameterSpecifications;
        }

        public TableBasedDeleteHandlerImpl(SessionFactoryImplementor factory, HqlSqlWalker walker, Queryable targetedPersister) {
            Delete delete;
            super(factory, walker, targetedPersister);
            ArrayList<String> statements = new ArrayList<String>();
            ArrayList<ParameterSpecification[]> parameterSpecifications = new ArrayList<ParameterSpecification[]>();
            DeleteStatement deleteStatement = (DeleteStatement)walker.getAST();
            FromElement fromElement = deleteStatement.getFromClause().getFromElement();
            String bulkTargetAlias = fromElement.getTableAlias();
            IdTableInfoImpl tableInfo = (IdTableInfoImpl)ReactiveBulkIdStrategy.this.getIdTableInfo(targetedPersister);
            AbstractTableBasedBulkIdHandler.ProcessedWhereClause processedWhereClause = this.processWhereClause(deleteStatement.getWhereClause());
            String idInsertSelect = this.generateIdInsertSelect(bulkTargetAlias, (IdTableInfo)tableInfo, processedWhereClause);
            statements.add(idInsertSelect);
            parameterSpecifications.add(processedWhereClause.getIdSelectParameterSpecifications().toArray(NO_PARAMS));
            for (Type type : targetedPersister.getPropertyTypes()) {
                if (!type.isCollectionType()) continue;
                CollectionType cType = (CollectionType)type;
                AbstractCollectionPersister cPersister = (AbstractCollectionPersister)factory.getMetamodel().collectionPersister(cType.getRole());
                if (!cPersister.isManyToMany()) continue;
                delete = new Delete().setTableName(cPersister.getTableName()).setWhere("(" + String.join((CharSequence)", ", cPersister.getKeyColumnNames()) + ") in (" + this.generateIdSubselect(targetedPersister, cPersister, (IdTableInfo)tableInfo) + ")");
                if (this.factory().getSessionFactoryOptions().isCommentsEnabled()) {
                    delete.setComment("bulk delete - m2m join table cleanup");
                }
                statements.add(delete.toStatementString());
                parameterSpecifications.add(NO_PARAMS);
            }
            String idSubselect = this.generateIdSubselect(targetedPersister, (IdTableInfo)tableInfo);
            String[] tableNames = targetedPersister.getConstraintOrderedTableNameClosure();
            String[][] columnNames = targetedPersister.getContraintOrderedTableKeyColumnClosure();
            for (int table = 0; table < tableNames.length; ++table) {
                String tableName = tableNames[table];
                String idColumnNames = String.join((CharSequence)", ", columnNames[table]);
                delete = new Delete().setTableName(tableName);
                delete.setWhere("(" + idColumnNames + ") in (" + idSubselect + ")");
                if (this.factory().getSessionFactoryOptions().isCommentsEnabled()) {
                    delete.setComment("bulk delete");
                }
                statements.add(delete.toStatementString());
                parameterSpecifications.add(NO_PARAMS);
            }
            this.statements = ArrayHelper.toStringArray(statements);
            this.parameterSpecifications = (ParameterSpecification[][])parameterSpecifications.toArray((T[])new ParameterSpecification[0][]);
        }

        @Override
        public String[] getSqlStatements() {
            return this.statements;
        }

        public int execute(SharedSessionContractImplementor session, QueryParameters queryParameters) {
            throw new UnsupportedOperationException();
        }
    }

    private class TableBasedUpdateHandlerImpl
    extends TempTableHandler
    implements MultiTableBulkIdStrategy.UpdateHandler {
        private final String[] statements;
        private final ParameterSpecification[][] parameterSpecifications;

        @Override
        public ParameterSpecification[][] getParameterSpecifications() {
            return this.parameterSpecifications;
        }

        public TableBasedUpdateHandlerImpl(SessionFactoryImplementor factory, HqlSqlWalker walker, Queryable targetedPersister) {
            super(factory, walker, targetedPersister);
            UpdateStatement updateStatement = (UpdateStatement)walker.getAST();
            FromElement fromElement = updateStatement.getFromClause().getFromElement();
            String bulkTargetAlias = fromElement.getTableAlias();
            IdTableInfoImpl tableInfo = (IdTableInfoImpl)ReactiveBulkIdStrategy.this.getIdTableInfo(targetedPersister);
            ArrayList assignments = walker.getAssignmentSpecifications();
            String[] tableNames = targetedPersister.getConstraintOrderedTableNameClosure();
            String[][] columnNames = targetedPersister.getContraintOrderedTableKeyColumnClosure();
            AbstractTableBasedBulkIdHandler.ProcessedWhereClause processedWhereClause = this.processWhereClause(updateStatement.getWhereClause());
            String idInsertSelect = this.generateIdInsertSelect(bulkTargetAlias, (IdTableInfo)tableInfo, processedWhereClause);
            ArrayList<String> statements = new ArrayList<String>();
            ArrayList<ParameterSpecification[]> parameterSpecifications = new ArrayList<ParameterSpecification[]>();
            statements.add(idInsertSelect);
            parameterSpecifications.add(processedWhereClause.getIdSelectParameterSpecifications().toArray(NO_PARAMS));
            String idSubselect = this.generateIdSubselect(targetedPersister, (IdTableInfo)tableInfo);
            for (int table = 0; table < tableNames.length; ++table) {
                String tableName = tableNames[table];
                List tableAssignments = assignments.stream().filter(assignment -> assignment.affectsTable(tableName)).collect(Collectors.toList());
                if (tableAssignments.isEmpty()) continue;
                ArrayList parameterList = new ArrayList();
                String idColumnNames = String.join((CharSequence)", ", columnNames[table]);
                Update update = new Update(walker.getDialect()).setTableName(tableName);
                update.setWhere("(" + idColumnNames + ") in (" + idSubselect + ")");
                if (this.factory().getSessionFactoryOptions().isCommentsEnabled()) {
                    update.setComment("bulk update");
                }
                for (AssignmentSpecification assignment2 : tableAssignments) {
                    update.appendAssignmentFragment(assignment2.getSqlAssignmentFragment());
                    if (assignment2.getParameters() == null) continue;
                    Collections.addAll(parameterList, assignment2.getParameters());
                }
                String sql = ReactiveBulkIdStrategy.this.parameters.process(update.toStatementString(), parameterList.size());
                statements.add(sql);
                parameterSpecifications.add(parameterList.toArray(NO_PARAMS));
            }
            this.statements = ArrayHelper.toStringArray(statements);
            this.parameterSpecifications = (ParameterSpecification[][])parameterSpecifications.toArray((T[])new ParameterSpecification[0][]);
        }

        public int execute(SharedSessionContractImplementor session, QueryParameters queryParameters) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getSqlStatements() {
            return this.statements;
        }
    }

    private abstract class TempTableHandler
    extends AbstractTableBasedBulkIdHandler
    implements StatementsWithParameters {
        private final Queryable targetedPersister;

        public TempTableHandler(SessionFactoryImplementor sessionFactory, HqlSqlWalker walker, Queryable targetedPersister) {
            super(sessionFactory, walker);
            this.targetedPersister = targetedPersister;
        }

        public Queryable getTargetedQueryable() {
            return this.targetedPersister;
        }

        @Override
        public CompletionStage<Integer> execute(ReactiveQueryExecutor session, QueryParameters queryParameters) {
            TempTableStatementsExecutor statementsExecutor = this.createStatementsExecutor(session);
            return statementsExecutor.createTempTable().thenCompose(zero -> StatementsWithParameters.super.execute(session, queryParameters)).thenCompose(statementsExecutor::dropTempTable);
        }

        private TempTableStatementsExecutor createStatementsExecutor(ReactiveQueryExecutor session) {
            return ReactiveBulkIdStrategy.this.db2 ? new Db2TempTableStatementsExecutor((IdTableInfoImpl)ReactiveBulkIdStrategy.this.getIdTableInfo(this.targetedPersister), session) : new LocalTempTableStatementsExecutor((IdTableInfoImpl)ReactiveBulkIdStrategy.this.getIdTableInfo(this.targetedPersister), session);
        }

        protected String generateIdInsertSelect(String tableAlias, IdTableInfo idTableInfo, AbstractTableBasedBulkIdHandler.ProcessedWhereClause whereClause) {
            String sql = super.generateIdInsertSelect(tableAlias, idTableInfo, whereClause);
            return ReactiveBulkIdStrategy.this.parameters.process(sql);
        }

        protected String generateIdSubselect(Queryable persister, AbstractCollectionPersister cPersister, IdTableInfo idTableInfo) {
            String sql = super.generateIdSubselect(persister, cPersister, idTableInfo);
            return ReactiveBulkIdStrategy.this.parameters.process(sql);
        }

        protected String generateIdSubselect(Queryable persister, IdTableInfo idTableInfo) {
            String sql = super.generateIdSubselect(persister, idTableInfo);
            return ReactiveBulkIdStrategy.this.parameters.process(sql);
        }

        protected void prepareForUse(Queryable persister, SharedSessionContractImplementor session) {
            throw new UnsupportedOperationException();
        }

        protected void releaseFromUse(Queryable persister, SharedSessionContractImplementor session) {
            throw new UnsupportedOperationException();
        }
    }

    private class Db2TempTableStatementsExecutor
    implements TempTableStatementsExecutor {
        private final String dropStatement;
        private final String createStatement;
        private final String deleteStatement;
        private final ReactiveQueryExecutor session;
        private String failedStatement;

        private Db2TempTableStatementsExecutor(IdTableInfoImpl tableInfo, ReactiveQueryExecutor session) {
            this.session = session;
            if (ReactiveBulkIdStrategy.this.createdGlobalTemporaryTables.add(tableInfo.getQualifiedIdTableName())) {
                this.dropStatement = tableInfo.getIdTableDropStatement();
                this.createStatement = tableInfo.getIdTableCreationStatement();
                ReactiveBulkIdStrategy.this.dropGlobalTemporaryTables.add(tableInfo.getIdTableDropStatement());
            } else {
                this.createStatement = null;
                this.dropStatement = null;
            }
            this.deleteStatement = ReactiveBulkIdStrategy.this.getIdTableSupport().getTruncateIdTableCommand() + " " + tableInfo.getQualifiedIdTableName();
        }

        @Override
        public CompletionStage<Integer> createTempTable() {
            if (this.createStatement == null) {
                return CompletionStages.zeroFuture();
            }
            return this.executeOutside(this.session, this.dropStatement).thenCompose(integer -> this.executeOutside(this.session, this.createStatement));
        }

        private CompletionStage<Integer> executeOutside(ReactiveQueryExecutor session, String sql) {
            this.failedStatement = sql;
            return session.getReactiveConnection().executeOutsideTransaction(sql).handle(this::ignoreException);
        }

        @Override
        public CompletionStage<Integer> dropTempTable(Integer total) {
            return this.session.getReactiveConnection().execute(this.deleteStatement).handle(this::ignoreException);
        }

        @Override
        public String getFailedStatement() {
            return this.failedStatement;
        }
    }

    private static class LocalTempTableStatementsExecutor
    implements TempTableStatementsExecutor {
        private final String createStatement;
        private final String dropStatement;
        private final ReactiveQueryExecutor session;
        private String failedStatement;

        private LocalTempTableStatementsExecutor(IdTableInfoImpl tableInfo, ReactiveQueryExecutor session) {
            this.session = session;
            this.createStatement = tableInfo.getIdTableCreationStatement();
            this.dropStatement = tableInfo.getIdTableDropStatement();
        }

        @Override
        public CompletionStage<Integer> createTempTable() {
            this.failedStatement = this.createStatement;
            return this.session.getReactiveConnection().executeUnprepared(this.createStatement).handle(this::ignoreException);
        }

        @Override
        public CompletionStage<Integer> dropTempTable(Integer total) {
            this.failedStatement = this.dropStatement;
            return this.session.getReactiveConnection().execute(this.dropStatement).handle(this::ignoreException).thenApply(zero -> total);
        }

        @Override
        public String getFailedStatement() {
            return this.failedStatement;
        }
    }

    private static interface TempTableStatementsExecutor {
        public CompletionStage<Integer> createTempTable();

        public CompletionStage<Integer> dropTempTable(Integer var1);

        public String getFailedStatement();

        default public Integer ignoreException(Void unused, Throwable throwable) {
            if (throwable != null) {
                LOG.debugf("Statement '%s' failed. Ignoring the exception: %s", (Object)this.getFailedStatement(), (Object)throwable.getMessage());
            }
            return 0;
        }
    }
}

