/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector;

import java.lang.reflect.Type;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicArrayType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.VectorJdbcType;

public class PGVectorTypeContributor
implements TypeContributor {
    private static final Type[] VECTOR_JAVA_TYPES = new Type[]{Float[].class, float[].class};

    public void contribute(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        Dialect dialect = ((JdbcServices)serviceRegistry.requireService(JdbcServices.class)).getDialect();
        if (dialect instanceof PostgreSQLDialect) {
            TypeConfiguration typeConfiguration = typeContributions.getTypeConfiguration();
            JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
            JdbcTypeRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeRegistry();
            BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
            BasicType floatBasicType = basicTypeRegistry.resolve(StandardBasicTypes.FLOAT);
            VectorJdbcType vectorJdbcType = new VectorJdbcType(jdbcTypeRegistry.getDescriptor(6));
            jdbcTypeRegistry.addDescriptor(10000, (JdbcType)vectorJdbcType);
            for (Type vectorJavaType : VECTOR_JAVA_TYPES) {
                basicTypeRegistry.register((BasicType)new BasicArrayType(floatBasicType, (JdbcType)vectorJdbcType, javaTypeRegistry.getDescriptor(vectorJavaType)), StandardBasicTypes.VECTOR.getName());
            }
            typeConfiguration.getDdlTypeRegistry().addDescriptor((DdlType)new DdlTypeImpl(10000, "vector($l)", "vector", dialect){

                public String getTypeName(Size size) {
                    return this.getTypeName(size.getArrayLength() == null ? null : Long.valueOf(size.getArrayLength().longValue()), null, null);
                }
            });
        }
    }
}

