/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.BitSet;
import org.hibernate.dialect.Dialect;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class VectorJdbcType
extends ArrayJdbcType {
    private static final float[] EMPTY = new float[0];

    public VectorJdbcType(JdbcType elementJdbcType) {
        super(elementJdbcType);
    }

    public int getDefaultSqlTypeCode() {
        return 10000;
    }

    public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        return typeConfiguration.getJavaTypeRegistry().resolveDescriptor(float[].class);
    }

    public void appendWriteExpression(String writeExpression, SqlAppender appender, Dialect dialect) {
        appender.append((CharSequence)"cast(");
        appender.append((CharSequence)writeExpression);
        appender.append((CharSequence)" as vector)");
    }

    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, (JdbcType)this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)this.getFloatArray(rs.getString(paramIndex)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)this.getFloatArray(statement.getString(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaTypeDescriptor.wrap((Object)this.getFloatArray(statement.getString(name)), options);
            }

            private float[] getFloatArray(String string) {
                int commaIndex;
                if (string.length() == 2) {
                    return EMPTY;
                }
                BitSet commaPositions = new BitSet();
                int size = 1;
                for (int i = 1; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c != ',') continue;
                    commaPositions.set(i);
                    ++size;
                }
                float[] result = new float[size];
                int floatStartIndex = 1;
                int index = 0;
                while ((commaIndex = commaPositions.nextSetBit(floatStartIndex)) != -1) {
                    result[index++] = Float.parseFloat(string.substring(floatStartIndex, commaIndex));
                    floatStartIndex = commaIndex + 1;
                }
                result[index] = Float.parseFloat(string.substring(floatStartIndex, string.length() - 1));
                return result;
            }
        };
    }
}

