/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vector;

import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.FunctionContributor;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.vector.VectorArgumentTypeResolver;
import org.hibernate.vector.VectorArgumentValidator;

public class PGVectorFunctionContributor
implements FunctionContributor {
    public void contributeFunctions(FunctionContributions functionContributions) {
        SqmFunctionRegistry functionRegistry = functionContributions.getFunctionRegistry();
        TypeConfiguration typeConfiguration = functionContributions.getTypeConfiguration();
        BasicTypeRegistry basicTypeRegistry = typeConfiguration.getBasicTypeRegistry();
        Dialect dialect = functionContributions.getDialect();
        if (dialect instanceof PostgreSQLDialect) {
            BasicType doubleType = basicTypeRegistry.resolve(StandardBasicTypes.DOUBLE);
            BasicType integerType = basicTypeRegistry.resolve(StandardBasicTypes.INTEGER);
            functionRegistry.patternDescriptorBuilder("cosine_distance", "?1<=>?2").setArgumentsValidator(StandardArgumentsValidators.composite((ArgumentsValidator[])new ArgumentsValidator[]{StandardArgumentsValidators.exactly((int)2), VectorArgumentValidator.INSTANCE})).setArgumentTypeResolver(VectorArgumentTypeResolver.INSTANCE).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant((BasicType)doubleType)).register();
            functionRegistry.patternDescriptorBuilder("euclidean_distance", "?1<->?2").setArgumentsValidator(StandardArgumentsValidators.composite((ArgumentsValidator[])new ArgumentsValidator[]{StandardArgumentsValidators.exactly((int)2), VectorArgumentValidator.INSTANCE})).setArgumentTypeResolver(VectorArgumentTypeResolver.INSTANCE).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant((BasicType)doubleType)).register();
            functionRegistry.registerAlternateKey("l2_distance", "euclidean_distance");
            functionRegistry.namedDescriptorBuilder("l1_distance").setArgumentsValidator(StandardArgumentsValidators.composite((ArgumentsValidator[])new ArgumentsValidator[]{StandardArgumentsValidators.exactly((int)2), VectorArgumentValidator.INSTANCE})).setArgumentTypeResolver(VectorArgumentTypeResolver.INSTANCE).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant((BasicType)doubleType)).register();
            functionRegistry.registerAlternateKey("taxicab_distance", "l1_distance");
            functionRegistry.patternDescriptorBuilder("negative_inner_product", "?1<#>?2").setArgumentsValidator(StandardArgumentsValidators.composite((ArgumentsValidator[])new ArgumentsValidator[]{StandardArgumentsValidators.exactly((int)2), VectorArgumentValidator.INSTANCE})).setArgumentTypeResolver(VectorArgumentTypeResolver.INSTANCE).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant((BasicType)doubleType)).register();
            functionRegistry.patternDescriptorBuilder("inner_product", "(?1<#>?2)*-1").setArgumentsValidator(StandardArgumentsValidators.composite((ArgumentsValidator[])new ArgumentsValidator[]{StandardArgumentsValidators.exactly((int)2), VectorArgumentValidator.INSTANCE})).setArgumentTypeResolver(VectorArgumentTypeResolver.INSTANCE).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant((BasicType)doubleType)).register();
            functionRegistry.namedDescriptorBuilder("vector_dims").setArgumentsValidator(StandardArgumentsValidators.composite((ArgumentsValidator[])new ArgumentsValidator[]{StandardArgumentsValidators.exactly((int)1), VectorArgumentValidator.INSTANCE})).setArgumentTypeResolver(VectorArgumentTypeResolver.INSTANCE).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant((BasicType)integerType)).register();
            functionRegistry.namedDescriptorBuilder("vector_norm").setArgumentsValidator(StandardArgumentsValidators.composite((ArgumentsValidator[])new ArgumentsValidator[]{StandardArgumentsValidators.exactly((int)1), VectorArgumentValidator.INSTANCE})).setArgumentTypeResolver(VectorArgumentTypeResolver.INSTANCE).setReturnTypeResolver(StandardFunctionReturnTypeResolvers.invariant((BasicType)doubleType)).register();
        }
    }

    public int ordinal() {
        return 200;
    }
}

