/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.boot;

import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.env.internal.JdbcEnvironmentImpl;
import org.hibernate.engine.jdbc.env.spi.ExtractedDatabaseMetaData;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;
import org.hibernate.testing.boot.JdbcConnectionAccessImpl;
import org.hibernate.testing.env.ConnectionProviderBuilder;

public class BasicTestingJdbcServiceImpl
implements JdbcServices,
ServiceRegistryAwareService {
    private JdbcEnvironment jdbcEnvironment;
    private ConnectionProvider connectionProvider;
    private Dialect dialect;
    private SqlStatementLogger sqlStatementLogger;
    private JdbcConnectionAccess jdbcConnectionAccess;
    private ServiceRegistry serviceRegistry;

    public void start() {
    }

    public void stop() {
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(boolean allowAggressiveRelease) throws SQLException {
        this.dialect = ConnectionProviderBuilder.getCorrespondingDialect();
        this.connectionProvider = ConnectionProviderBuilder.buildConnectionProvider(allowAggressiveRelease);
        this.sqlStatementLogger = new SqlStatementLogger(true, false, false);
        this.jdbcConnectionAccess = new JdbcConnectionAccessImpl(this.connectionProvider);
        Connection jdbcConnection = this.connectionProvider.getConnection();
        try {
            this.jdbcEnvironment = new JdbcEnvironmentImpl(jdbcConnection.getMetaData(), this.dialect, this.jdbcConnectionAccess);
        }
        finally {
            try {
                this.connectionProvider.closeConnection(jdbcConnection);
            }
            catch (SQLException sQLException) {}
        }
    }

    public void release() {
        if (this.connectionProvider instanceof Stoppable) {
            ((Stoppable)this.connectionProvider).stop();
        }
    }

    public JdbcEnvironment getJdbcEnvironment() {
        return this.jdbcEnvironment;
    }

    public JdbcConnectionAccess getBootstrapJdbcConnectionAccess() {
        return this.jdbcConnectionAccess;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public LobCreator getLobCreator(LobCreationContext lobCreationContext) {
        return this.jdbcEnvironment.getLobCreatorBuilder().buildLobCreator(lobCreationContext);
    }

    public SqlStatementLogger getSqlStatementLogger() {
        return this.sqlStatementLogger;
    }

    public SqlExceptionHelper getSqlExceptionHelper() {
        return this.jdbcEnvironment.getSqlExceptionHelper();
    }

    public ExtractedDatabaseMetaData getExtractedMetaDataSupport() {
        return this.jdbcEnvironment.getExtractedDatabaseMetaData();
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }
}

