/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.util.LinkedHashSet;
import javax.persistence.EntityManagerFactory;
import org.hibernate.SessionFactory;
import org.hibernate.boot.registry.classloading.internal.AggregatedClassLoader;
import org.hibernate.boot.registry.classloading.internal.TcclLookupPrecedence;
import org.hibernate.osgi.OsgiClassLoader;
import org.hibernate.osgi.OsgiJtaPlatform;
import org.hibernate.osgi.OsgiPersistenceProvider;
import org.hibernate.osgi.OsgiServiceUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class OsgiPersistenceProviderService
implements ServiceFactory {
    private OsgiJtaPlatform osgiJtaPlatform;
    private OsgiServiceUtil osgiServiceUtil;

    public OsgiPersistenceProviderService(OsgiJtaPlatform osgiJtaPlatform, OsgiServiceUtil osgiServiceUtil) {
        this.osgiJtaPlatform = osgiJtaPlatform;
        this.osgiServiceUtil = osgiServiceUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(Bundle requestingBundle, ServiceRegistration registration) {
        OsgiClassLoader osgiClassLoader = new OsgiClassLoader();
        osgiClassLoader.addBundle(requestingBundle);
        osgiClassLoader.addBundle(FrameworkUtil.getBundle(SessionFactory.class));
        osgiClassLoader.addBundle(FrameworkUtil.getBundle(EntityManagerFactory.class));
        ClassLoader originalTccl = Thread.currentThread().getContextClassLoader();
        LinkedHashSet<ClassLoader> newTcclDelegates = new LinkedHashSet<ClassLoader>();
        newTcclDelegates.add(osgiClassLoader);
        newTcclDelegates.add(originalTccl);
        AggregatedClassLoader newTccl = new AggregatedClassLoader(newTcclDelegates, TcclLookupPrecedence.NEVER);
        Thread.currentThread().setContextClassLoader((ClassLoader)newTccl);
        try {
            OsgiPersistenceProvider osgiPersistenceProvider = new OsgiPersistenceProvider(osgiClassLoader, this.osgiJtaPlatform, this.osgiServiceUtil, requestingBundle);
            return osgiPersistenceProvider;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalTccl);
        }
    }

    public void ungetService(Bundle requestingBundle, ServiceRegistration registration, Object service) {
    }
}

