
package org.hibernate.jpamodelgen.xml.jaxb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * 
 *         Metadata that applies to the persistence unit and not just to 
 *         the mapping file in which it is contained. 
 * 
 *         If the xml-mapping-metadata-complete element is specified,
 *         the complete set of mapping metadata for the persistence unit 
 *         is contained in the XML mapping files for the persistence unit.
 * 
 *       
 * 
 * <p>Java class for persistence-unit-metadata complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="persistence-unit-metadata">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="xml-mapping-metadata-complete" type="{https://jakarta.ee/xml/ns/persistence/orm}emptyType" minOccurs="0"/>
 *         <element name="persistence-unit-defaults" type="{https://jakarta.ee/xml/ns/persistence/orm}persistence-unit-defaults" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "persistence-unit-metadata", namespace = "https://jakarta.ee/xml/ns/persistence/orm", propOrder = {
    "description",
    "xmlMappingMetadataComplete",
    "persistenceUnitDefaults"
})
public class PersistenceUnitMetadata {

    @XmlElement(namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected String description;
    @XmlElement(name = "xml-mapping-metadata-complete", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected EmptyType xmlMappingMetadataComplete;
    @XmlElement(name = "persistence-unit-defaults", namespace = "https://jakarta.ee/xml/ns/persistence/orm")
    protected PersistenceUnitDefaults persistenceUnitDefaults;

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Gets the value of the xmlMappingMetadataComplete property.
     * 
     * @return
     *     possible object is
     *     {@link EmptyType }
     *     
     */
    public EmptyType getXmlMappingMetadataComplete() {
        return xmlMappingMetadataComplete;
    }

    /**
     * Sets the value of the xmlMappingMetadataComplete property.
     * 
     * @param value
     *     allowed object is
     *     {@link EmptyType }
     *     
     */
    public void setXmlMappingMetadataComplete(EmptyType value) {
        this.xmlMappingMetadataComplete = value;
    }

    /**
     * Gets the value of the persistenceUnitDefaults property.
     * 
     * @return
     *     possible object is
     *     {@link PersistenceUnitDefaults }
     *     
     */
    public PersistenceUnitDefaults getPersistenceUnitDefaults() {
        return persistenceUnitDefaults;
    }

    /**
     * Sets the value of the persistenceUnitDefaults property.
     * 
     * @param value
     *     allowed object is
     *     {@link PersistenceUnitDefaults }
     *     
     */
    public void setPersistenceUnitDefaults(PersistenceUnitDefaults value) {
        this.persistenceUnitDefaults = value;
    }

}
